﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/settings/system/settings_Tv.h>
#include <nvnflinger_service.h>
#include <nvdc.h>
#include <hardware/hwcomposer_defs.h>

namespace nns {

class VideoConfigUtility
{
private:
    android::sp<android::IBinder> m_Video;
    android::sp<android::SurfaceComposerClient> m_Client;
    nvdcHandle m_NvdcHandle;

public:
    enum EdidVic
    {
        EdidVic_Vic3,   // 480p (16:9)
        EdidVic_Vic4,   // 720p (16:9)
        EdidVic_Vic16,  // 1080p (16:9)
    };

    // displayId:
    //  - android::ISurfaceComposer::eDisplayIdMain
    //  - android::ISurfaceComposer::eDisplayIdHdmi
    NN_IMPLICIT VideoConfigUtility(int32_t displayId) NN_NOEXCEPT;
    ~VideoConfigUtility() NN_NOEXCEPT;
    bool ShowDisplayInfo() NN_NOEXCEPT;
    bool SetActiveConfigMode(int configMode) NN_NOEXCEPT;
    int GetActiveConfigMode() NN_NOEXCEPT;
    int GetDisplayInfoCount() NN_NOEXCEPT;
    bool IsDisplayConnected() NN_NOEXCEPT;
    int GetConfigMode(int width, int height) NN_NOEXCEPT;   // これいらんかも…
    int FindDisplayConfigMode(uint32_t width, uint32_t height, float fps) NN_NOEXCEPT;
    int FindDisplayConfigModeFromVic(EdidVic vic) NN_NOEXCEPT;
    void SetDisplayPowerMode(int powerMode) NN_NOEXCEPT;
    bool SetVrrEnabled(bool enabled) NN_NOEXCEPT;

    // rangeId:
    //  - DISPLAY_RGB_Limited
    //  - DISPLAY_RGB_Full
    bool SetRgbRange(int rangeId) NN_NOEXCEPT;
    bool GetRgbRange(int* pRangeId) NN_NOEXCEPT;

    // contentTypeId:
    //  - nn::settings::system::HdmiContentType_None
    //  - nn::settings::system::HdmiContentType_Game
    bool SetContentType(nn::settings::system::HdmiContentType contentTypeId) NN_NOEXCEPT;
    bool GetContentType(nn::settings::system::HdmiContentType* pContentTypeId) NN_NOEXCEPT;
    bool TrackPerformance(int intervalSeconds) NN_NOEXCEPT;

    bool GetLcdPanelVendor(uint8_t outVendorId[3]) NN_NOEXCEPT;
    bool SetVfp(int vfp) NN_NOEXCEPT;
};

}
