﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_Log.h>
#include <nnt.h>

#define NNT_GRC_EXPECT_SUCCESS(ActualValue) \
    do{                                             \
        nn::Result nnt_grc_expect_error_actual = ActualValue;    \
        if(nnt_grc_expect_error_actual.IsFailure())  \
        {                                           \
            NN_LOG("EXPECT_SUCCESS failed.\n");     \
            NN_LOG("  Actual  : %d-%d\n", nnt_grc_expect_error_actual.GetModule(), nnt_grc_expect_error_actual.GetDescription()); \
            FAIL();                                 \
        }                                           \
        else{ SUCCEED(); }                          \
    } while(NN_STATIC_CONDITION(false))

#define NNT_GRC_EXPECT_ERROR(ExpectType,ActualValue) \
    do{                                             \
        nn::Result nnt_grc_expect_error_actual = ActualValue;    \
        if(!ExpectType::Includes(nnt_grc_expect_error_actual))   \
        {                                           \
            nn::Result nnt_grc_expect_error_expect = ExpectType();   \
            NN_LOG("EXPECT_ERROR failed.\n");                       \
            NN_LOG("  Expected: %d-%d\n", nnt_grc_expect_error_expect.GetModule(), nnt_grc_expect_error_expect.GetDescription()); \
            NN_LOG("  Actual  : %d-%d\n", nnt_grc_expect_error_actual.GetModule(), nnt_grc_expect_error_actual.GetDescription()); \
            FAIL();                                 \
        }                                           \
        else{ SUCCEED(); }                          \
    } while(NN_STATIC_CONDITION(false))


#define NNT_GRC_TESTCASENAME TestOffscreen

#define NNT_GRC_TEST_SERVERSTATE(name) TEST(NNT_GRC_TESTCASENAME, ServerState_ ## name)
