﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @examplesource{ManagedUniformBuffer.h,PageSampleNvnTutorialLibrary}
 *
 * @brief
 *  The ManagedUniformBuffer class is used to
 *  create uniform buffers from the double
 *  buffered memory used by the UniformBufferManager.
 *  The managed uniform buffer mainly consists of
 *  a size, an offset into the UniformBufferManager
 *  memory, and a buffer address.
 */

#pragma once

#include <nvn/nvn.h>

class UniformBufferManager;
class ManagedUniformBuffer
{
    public:
        ~ManagedUniformBuffer();
        void SetData(void* pData, size_t dataSize);
        void* GetMappedPointer();
        NVNbufferAddress GetCurrentBufferAddress();
        size_t GetSizeOfBuffer() const;

        void Reset();

    private:
        ManagedUniformBuffer(NVNdevice* pDevice, size_t bufferSize, NVNbufferAddress address, char* pMappedBuffer, UniformBufferManager* pManager);

        NVNdevice*            m_pDevice;
        size_t                m_BufferSize;
        NVNbufferAddress      m_BufferAddress;
        char*                 m_pMappedBuffer;
        ptrdiff_t             m_BufferOffset;
        UniformBufferManager* m_pManager;

        friend class UniformBufferManager;
};
