﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Assert.h>
#include <nn/os.h>
#include <nn/init.h>

namespace{
    static const size_t ApplicationHeapSize            = 512 * 1024 * 1024;
    static const size_t MallocHeapSize                 = 256 * 1024 * 1024;
}

extern "C" void nninitStartup()
{
    nn::Result result;
    // アプリケーション全体で使うヒープサイズを設定
    {
        result = nn::os::SetMemoryHeapSize(ApplicationHeapSize);
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    }
#ifndef _WIN32
    // malloc 用のメモリを設定
    {
        uintptr_t heapAddress = 0;
        result = nn::os::AllocateMemoryBlock(&heapAddress, MallocHeapSize);
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
        nn::init::InitializeAllocator(reinterpret_cast<void*>(heapAddress), MallocHeapSize);
    }
#endif
}
