﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>

#include "testGfxUtil_Application.h"

#include "gfxUtilGpuBenchmark_JsonStreamer.h"
#include "gfxUtilGpuBenchmark_Factory.h"
#include "gfxUtilGpuBenchmark_PlatformId.h"

void DoUpdateTimingsMode(
    ApplicationTestData* pTestData,
    const char* inputFilePath,
    const char* outputFilePath,
    const char* testCaseFilter)
{
    if (!TestFilePathMountPointExist(inputFilePath)
        || !TestFilePathMountPointExist(outputFilePath))
    {
        NN_LOG("Invalid mount point in file path\n");
        return;
    }

    nnt::gfx::util::json::Document* pJsonDocument = nullptr;
    nnt::gfx::util::json::Create(&pJsonDocument, nullptr);
    nn::Result result = nnt::gfx::util::json::LoadFromFile(pJsonDocument, inputFilePath);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);

    nnt::gfx::util::json::TestCaseIterator* testCaseIterator = nullptr;
    const int filterBufferSize = 128;
    char filterBuffer[filterBufferSize] = {};
    nnt::gfx::util::GetPlatformId(filterBuffer, filterBufferSize);
    if (testCaseFilter != nullptr)
    {
        strncat(filterBuffer, testCaseFilter, filterBufferSize - 1);
        filterBuffer[filterBufferSize - 1] = '\0';
    }

    nnt::gfx::util::GpuBenchmark* pGpuBenchmark = nullptr;

    nnt::gfx::util::json::InitializeTestIterator(&testCaseIterator, pJsonDocument);

    while (nnt::gfx::util::json::MoveToNextTestCase(filterBuffer, testCaseIterator))
    {
        pGpuBenchmark = InitializeBenchmarkFromTestCase(pTestData, testCaseIterator);

        int warmUpCount = nnt::gfx::util::json::GetTestCaseWarmUpCount(testCaseIterator);
        int repeatCount = nnt::gfx::util::json::GetTestCaseRepeatCount(testCaseIterator);
        const char* testCaseId = nnt::gfx::util::json::GetTestCaseId(testCaseIterator);

        CreateTestCaseData(
            pTestData, pGpuBenchmark,
            warmUpCount, repeatCount,
            pJsonDocument, testCaseId);

        FinalizeBenchmark(pTestData, pGpuBenchmark);
    }

    nnt::gfx::util::json::FinalizeTestIterator(testCaseIterator);

    nnt::gfx::util::json::SaveToFile(pJsonDocument, outputFilePath);
    nnt::gfx::util::json::Finalize(pJsonDocument);
}

