﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testGfxUtil_Application.h"
#include "testGfxUtil_ControllerInput.h"

ApplicationMode DoSelectMode(ApplicationTestData* pTestData)
{
    InitializeControllerInput();


    ApplicationMode nextMode = ApplicationMode_Interactive;

    while (true)
    {
        pTestData->debugFontWriter.SetCursor(0.0f, 0.0f);
        pTestData->debugFontWriter.SetScale(1.0f, 1.0f);
        pTestData->debugFontWriter.Print("A: Interactive mode\n");
        pTestData->debugFontWriter.Print("B: Replay mode\n");
        pTestData->debugFontWriter.Print("X: Find max power usage\n");
#if defined(NNT_GFX_UTIL_ENABLE_LOP)
        pTestData->debugFontWriter.Print("Y: LOP profiling\n");
#endif
        pTestData->debugFontWriter.Print("+: Exit\n");

        DrawFrame(pTestData, nullptr);

        unsigned int buttonMask = UpdateControllerInput(pTestData->pHostContext);
        if (buttonMask & UserInput_A)
        {
            nextMode = ApplicationMode_Interactive;
            break;
        }
        if (buttonMask & UserInput_B)
        {
            nextMode = ApplicationMode_Replay;
            break;
        }
        if (buttonMask & UserInput_X)
        {
            nextMode = ApplicationMode_FindMaxPower;
            break;
        }
#if defined(NNT_GFX_UTIL_ENABLE_LOP)
        if (buttonMask & UserInput_Y)
        {
            nextMode = ApplicationMode_Profile;
            break;
        }
#endif
        if (buttonMask & UserInput_Exit)
        {
            nextMode = ApplicationMode_Exit;
            break;
        }
    }

    return nextMode;
}
