﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>

#include <nn/nn_Assert.h>
#if defined(NN_BUILD_TARGET_PLATFORM_OS_NN)
#include <nn/oe.h>
#endif

#include "gfxUtilGpuBenchmark_PlatformId.h"
#include "gfxUtilGpuBenchmark_GpuBenchmark.h"

namespace nnt { namespace gfx { namespace util {


void GetPlatformId(char* pDestinationBuffer, int destinationBufferSize)
{
#if defined(NN_BUILD_TARGET_PLATFORM_OS_NN)
    const char* modeSuffix = nullptr;

    nn::oe::OperationMode opMode = nn::oe::GetOperationMode();
    switch (opMode)
    {
    case nn::oe::OperationMode_Handheld:
        {
            modeSuffix = "Handheld";
        }
        break;
    case nn::oe::OperationMode_Console:
        {
            modeSuffix = "Console";
        }
        break;
    default:
        NN_UNEXPECTED_DEFAULT;
    }
    strncpy(pDestinationBuffer, modeSuffix, destinationBufferSize - 1);
    pDestinationBuffer[destinationBufferSize - 1] = '\0';
#else
    const char* DefaultPlatformId = "Default";
    strncpy(pDestinationBuffer, DefaultPlatformId, destinationBufferSize - 1);
    pDestinationBuffer[destinationBufferSize - 1] = '\0';
#endif

#if defined(NN_SDK_BUILD_DEBUG)
    strcat(pDestinationBuffer, "Debug");
#elif defined(NN_SDK_BUILD_DEVELOP)
    strcat(pDestinationBuffer, "Develop");
#else
    strcat(pDestinationBuffer, "Release");
#endif
}

void MakeTestId(char* pDestinationBuffer, int destinationBufferSize, const GpuBenchmark* pGpuBenchmark)
{
    GetPlatformId(pDestinationBuffer, destinationBufferSize);
    std::strncat(pDestinationBuffer, pGpuBenchmark->GetName(), destinationBufferSize);
}


} } } // namespace nnt { namespace gfx { namespace util {
