﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once


#include "gfxUtilGpuBenchmark_GpuBenchmark.h"


#include "gfxUtilGpuBenchmark_Property.h"
#include "gfxUtilGpuBenchmark_PropertyArray.h"
#include "gfxUtilGpuBenchmark_ResShader.h"

#include <nn/gfx/gfx_Types.h>
#include <nn/gfx/gfx_Texture.h>
#include <nn/gfx/gfx_State.h>

namespace nnt { namespace gfx { namespace util {

class GpuBenchmarkMrt : public GpuBenchmark
{
public:
    static const char*  ClassName;

    enum Dummy1Value
    {
        Dummy1Value_0,
        Dummy1Value_1
    };

private:
    static const int                    m_MrtCountMax = 4;

    int                                 m_RenderSize;
    nn::gfx::ImageFormat                m_RenderFormat;
    int                                 m_MrtCount;

    nn::gfx::Texture                    m_RenderTexture[m_MrtCountMax];
    nn::gfx::ColorTargetView            m_RenderTextureColorTargetView[m_MrtCountMax];
    nn::gfx::ViewportScissorState       m_ViewportScissorState;

    nn::gfx::Buffer                     m_RectangleVertexBuffer;

    ResShader                           m_ResShader;

    nn::gfx::Buffer                     m_OutputCopyBuffer;
    size_t                              m_OutputCopyBufferTotalSize;
    size_t                              m_OutputCopyBufferRenderTargetSize[m_MrtCountMax];

    enum Property
    {
        Property_RenderSize,
        Property_RenderFormat,
        Property_MrtCount,
        Property_Count,
    };

    PropertyArray<Property_Count>       m_PropertyArray;

public:
                                                GpuBenchmarkMrt();
    virtual                                     ~GpuBenchmarkMrt();

    virtual void                                Initialize(ResourceAllocator* pResourceAllocator) NN_OVERRIDE;
    virtual void                                Finalize(ResourceAllocator* pResourceAllocator) NN_OVERRIDE;

    virtual void                                InitializeGfxObjects(ResourceAllocator* pResourceAllocator, nn::gfx::Device* pDevice) NN_OVERRIDE;
    virtual void                                FinalizeGfxObjects(ResourceAllocator* pResourceAllocator, nn::gfx::Device* pDevice) NN_OVERRIDE;

    int                                         GetRenderSize() const;
    void                                        SetRenderSize(int dimension);

    nn::gfx::ImageFormat                        GetRenderFormat() const;
    void                                        SetRenderFormat(nn::gfx::ImageFormat format);

    int                                         GetMrtCount() const;
    void                                        SetMrtCount(int count);

    virtual void                                PreBenchmark(nn::gfx::CommandBuffer* pTestCommandBuffer) NN_OVERRIDE;
    virtual void                                DoBenchmark(nn::gfx::CommandBuffer* pTestCommandBuffer, int runCount) NN_OVERRIDE;

    virtual void                                PrintResults(nn::TimeSpan cpuTimeElapsed, nn::TimeSpan gpuTimeElapsed, int runCount, nn::gfx::util::DebugFontTextWriter* pDebugFontTextWriter) NN_OVERRIDE;

    virtual void                                CopyResultToBuffer(nn::gfx::CommandBuffer* pCommandBuffer) NN_OVERRIDE;
    virtual void                                MapResultBuffer(void** pOutBuffer, size_t* pOutBufferSize) NN_OVERRIDE;
    virtual void                                UnmapResultBuffer() NN_OVERRIDE;

    virtual const char*                         GetName() const NN_OVERRIDE;
    virtual BenchmarkType                       GetType() const NN_OVERRIDE;
    virtual int                                 GetPropertyCount() const NN_OVERRIDE;
    virtual int                                 FillPropertyList(const GpuBenchmarkPropertyHolder** ppDestinationArray, int destinationArrayMaxSize) const NN_OVERRIDE;
    virtual int                                 FillPropertyList(GpuBenchmarkPropertyHolder** ppDestinationArray, int destinationArrayMaxSize) NN_OVERRIDE;
    virtual GpuBenchmarkPropertyHolder*         FindPropertyByName(const char* propertyName) NN_OVERRIDE;
    virtual GpuBenchmarkPropertyHolder*         GetPropertyByIndex(int index) NN_OVERRIDE;

};

inline int GpuBenchmarkMrt::GetRenderSize() const
{
    return m_RenderSize;
}

inline void GpuBenchmarkMrt::SetRenderSize(int width)
{
    m_RenderSize = width;
}

inline nn::gfx::ImageFormat GpuBenchmarkMrt::GetRenderFormat() const
{
    return m_RenderFormat;
}

inline void GpuBenchmarkMrt::SetRenderFormat(nn::gfx::ImageFormat format)
{
    m_RenderFormat = format;
}
inline int GpuBenchmarkMrt::GetMrtCount() const
{
    return m_MrtCount;
}

inline void GpuBenchmarkMrt::SetMrtCount(int count)
{
    m_MrtCount = count;
}



} } } // namespace nnt { namespace gfx { namespace util {
