﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once


#include "gfxUtilGpuBenchmark_GpuBenchmark.h"

#include "gfxUtilGpuBenchmark_Property.h"
#include "gfxUtilGpuBenchmark_PropertyArray.h"
#include "gfxUtilGpuBenchmark_ResShader.h"

#include <nn/gfx/gfx_Texture.h>
#include <nn/gfx/gfx_State.h>

namespace nnt { namespace gfx { namespace util {

class GpuBenchmarkDepthTest : public GpuBenchmark
{
public:
    static const char*  ClassName;


    enum DepthBufferDirection
    {
        DepthBufferDirection_Greater,
        DepthBufferDirection_Less,
    };

    enum EarlyZ
    {
        EarlyZ_On,
        EarlyZ_Off,
    };


private:
    static const int                    m_RenderSize            = 2048;
    static const nn::gfx::ImageFormat   m_RenderFormat          = nn::gfx::ImageFormat_R8_G8_B8_A8_Unorm;
    static const nn::gfx::TileMode      m_TileMode              = nn::gfx::TileMode_Optimal;
    nn::gfx::ImageFormat                m_DepthBufferFormat     = nn::gfx::ImageFormat_D24_Unorm_S8_Uint;

    nn::gfx::Texture                    m_RenderTexture;
    nn::gfx::Texture                    m_DepthStencilTexture;
    nn::gfx::ColorTargetView            m_RenderTextureColorTargetView;
    nn::gfx::DepthStencilView           m_DepthStencilView;
    nn::gfx::ViewportScissorState       m_ViewportScissorState;

    nn::gfx::DepthStencilState          m_DepthStencilState;

    ResShader                           m_ResShader;

    nn::gfx::Buffer                     m_OutputCopyBuffer;
    size_t                              m_OutputCopyBufferSize;

    int                                 m_OverdrawCount;
    DepthBufferDirection                m_DepthBufferDirection;
    EarlyZ                              m_EarlyZ;

    enum Property
    {
        Property_DepthBufferDirection,
        Property_EarlyZ,
        Property_Count,
    };
    PropertyArray<Property_Count>                    m_PropertyArray;

public:
                                                GpuBenchmarkDepthTest();
    virtual                                     ~GpuBenchmarkDepthTest();

    virtual void                                Initialize(ResourceAllocator* pResourceAllocator) NN_OVERRIDE;
    virtual void                                Finalize(ResourceAllocator* pResourceAllocator) NN_OVERRIDE;

    virtual void                                InitializeGfxObjects(ResourceAllocator* pResourceAllocator, nn::gfx::Device* pDevice) NN_OVERRIDE;
    virtual void                                FinalizeGfxObjects(ResourceAllocator* pResourceAllocator, nn::gfx::Device* pDevice) NN_OVERRIDE;

    virtual void                                PreBenchmark(nn::gfx::CommandBuffer* pTestCommandBuffer) NN_OVERRIDE;
    virtual void                                DoBenchmark(nn::gfx::CommandBuffer* pTestCommandBuffer, int runCount) NN_OVERRIDE;

    virtual void                                PrintResults(nn::TimeSpan gpuTimeElapsed, nn::TimeSpan cpuTimeElapsed, int runCount, nn::gfx::util::DebugFontTextWriter* pDebugFontTextWriter) NN_OVERRIDE;

    virtual void                                CopyResultToBuffer(nn::gfx::CommandBuffer* pCommandBuffer) NN_OVERRIDE;
    virtual void                                MapResultBuffer(void** pOutBuffer, size_t* pOutBufferSize) NN_OVERRIDE;
    virtual void                                UnmapResultBuffer() NN_OVERRIDE;

    DepthBufferDirection                        GetDepthBufferDirection() const;
    void                                        SetDepthBufferDirection(DepthBufferDirection value);

    EarlyZ                                      GetEarlyZ() const;
    void                                        SetEarlyZ(EarlyZ value);

    virtual const char*                         GetName() const NN_OVERRIDE;
    virtual BenchmarkType                       GetType() const NN_OVERRIDE;
    virtual int                                 GetPropertyCount() const NN_OVERRIDE;
    virtual int                                 FillPropertyList(const GpuBenchmarkPropertyHolder** ppDestinationArray, int destinationArrayMaxSize) const NN_OVERRIDE;
    virtual int                                 FillPropertyList(GpuBenchmarkPropertyHolder** ppDestinationArray, int destinationArrayMaxSize) NN_OVERRIDE;
    virtual GpuBenchmarkPropertyHolder*         FindPropertyByName(const char* propertyName) NN_OVERRIDE;
    virtual GpuBenchmarkPropertyHolder*         GetPropertyByIndex(int index) NN_OVERRIDE;

private:
    nn::gfx::ComparisonFunction                 GetComparisonFunction() const;
    float                                       GetDepthClearValue() const;
};

inline GpuBenchmarkDepthTest::DepthBufferDirection GpuBenchmarkDepthTest::GetDepthBufferDirection() const
{
    return m_DepthBufferDirection;
}

inline void GpuBenchmarkDepthTest::SetDepthBufferDirection(DepthBufferDirection value)
{
    m_DepthBufferDirection = value;
}

inline GpuBenchmarkDepthTest::EarlyZ GpuBenchmarkDepthTest::GetEarlyZ() const
{
    return m_EarlyZ;
}

inline void GpuBenchmarkDepthTest::SetEarlyZ(EarlyZ value)
{
    m_EarlyZ = value;
}




} } } // namespace nnt { namespace gfx { namespace util {
