﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "gfxUtilGpuBenchmark_Types.h"

namespace nnt { namespace gfx { namespace util {

class ResourceAllocator;
class GpuBenchmark;

GpuBenchmark*   CreateBenchmarkFromName(const char* benchmarkName, ResourceAllocator* pResourceAllocator);
GpuBenchmark*   CreateBenchmarkFromType(BenchmarkType benchmarkType, ResourceAllocator* pResourceAllocator);
const char*     GetBenchmarkNameFromType(BenchmarkType benchmarkType);
void            DestroyBenchmark(GpuBenchmark* pGpuBenchmark, ResourceAllocator* pResourceAllocator);


} } } // namespace nnt { namespace gfx { namespace util {
