﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "gfxUtilGpuBenchmark_Factory.h"

#include "gfxUtilGpuBenchmark_GpuBenchmarkBlending.h"
#include "gfxUtilGpuBenchmark_GpuBenchmarkBlitTexture.h"
#include "gfxUtilGpuBenchmark_GpuBenchmarkCompositeTest.h"
#include "gfxUtilGpuBenchmark_GpuBenchmarkDepthTest.h"
#include "gfxUtilGpuBenchmark_GpuBenchmarkFillrate.h"
#include "gfxUtilGpuBenchmark_GpuBenchmarkMrt.h"
#include "gfxUtilGpuBenchmark_GpuBenchmarkShader.h"
#include "gfxUtilGpuBenchmark_GpuBenchmarkTextureFetch.h"
#include "gfxUtilGpuBenchmark_GpuBenchmarkVertexFetch.h"
#include "gfxUtilGpuBenchmark_ResourceAllocator.h"

#include "gfxUtilGpuBenchmark_TypesGen.h"


namespace nnt { namespace gfx { namespace util {

namespace
{

    template<typename T>
    GpuBenchmark* AllocateBenchmark(ResourceAllocator* pResourceAllocator)
    {
        return new (pResourceAllocator->AllocateMemory(sizeof(T), NN_ALIGNOF(T))) T();
    }


    void FreeBenchmark(GpuBenchmark* pGpuBenchmark, ResourceAllocator* pResourceAllocator)
    {
        pGpuBenchmark->~GpuBenchmark();
        pResourceAllocator->FreeMemory(pGpuBenchmark);
    }


    template<typename T>
    GpuBenchmark* CreateIfNameMatch(const char* name, ResourceAllocator* pResourceAllocator)
    {
        if (strcmp(T::ClassName, name) == 0)
        {
            return AllocateBenchmark<T>(pResourceAllocator);
        }

        return nullptr;
    }
}


GpuBenchmark* CreateBenchmarkFromName(const char* benchmarkName, ResourceAllocator* pResourceAllocator)
{
    GpuBenchmark* pResult = nullptr;

#define GPU_BENCHMARK_DEFINE_CREATE_FROM_NAME(_n)                                               \
    do {                                                                                        \
        pResult = CreateIfNameMatch<GpuBenchmark ## _n>(benchmarkName, pResourceAllocator);     \
        if (pResult != nullptr)                                                                 \
            return pResult;                                                                     \
    } while (false);

    GPU_BENCHMARK_TYPES_GEN(GPU_BENCHMARK_DEFINE_CREATE_FROM_NAME);

    NN_ABORT();
    return nullptr;
}

GpuBenchmark* CreateBenchmarkFromType(BenchmarkType benchmarkType, ResourceAllocator* pResourceAllocator)
{
    GpuBenchmark* pGpuBenchmark = nullptr;

#define GPU_BENCHMARK_DEFINE_CREATE_FROM_TYPE(_n)                                       \
    case BenchmarkType_ ## _n:                                                          \
        {                                                                               \
            pGpuBenchmark = AllocateBenchmark<GpuBenchmark ## _n>(pResourceAllocator);  \
        }                                                                               \
        break;

    switch (benchmarkType)
    {
    GPU_BENCHMARK_TYPES_GEN(GPU_BENCHMARK_DEFINE_CREATE_FROM_TYPE);

    default:
        {
            NN_UNEXPECTED_DEFAULT;
        }
        break;
    }

    NN_ASSERT(strcmp(GetBenchmarkNameFromType(benchmarkType), pGpuBenchmark->GetName()) == 0);
    return pGpuBenchmark;
}

const char* GetBenchmarkNameFromType(BenchmarkType benchmarkType)
{

#define GPU_BENCHMARK_DEFINE_GET_CLASS_NAME(_n)                                         \
    case BenchmarkType_ ## _n:                                                          \
        {                                                                               \
            return GpuBenchmark ## _n::ClassName;                                       \
        }                                                                               \

    switch (benchmarkType)
    {
    GPU_BENCHMARK_TYPES_GEN(GPU_BENCHMARK_DEFINE_GET_CLASS_NAME);

    default:
        {
            NN_UNEXPECTED_DEFAULT;
        }
        break;
    }
}

void DestroyBenchmark(GpuBenchmark* pGpuBenchmark, ResourceAllocator* pResourceAllocator)
{
    FreeBenchmark(pGpuBenchmark, pResourceAllocator);
}

} } } // namespace nnt { namespace gfx { namespace util {

