﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

INOUT Varying
{
    vec2 texCoord;
} InOut;

#if VERTEX_SHADER

in int gl_VertexID;

void main()
{
    float x = float(gl_VertexID & 0x01);
    float y = float((gl_VertexID & 0x02) >> 1);
    float clipSpaceX = (x * 2.0) - 1.0;
    float clipSpaceY = 1.0 - (y * 2.0);

    gl_Position = vec4(clipSpaceX, clipSpaceY, 0.5f, 1.0f);
    InOut.texCoord = vec2(x, y);
}

#endif


#if PIXEL_SHADER

layout(location = 0) out vec4 o_Color;

layout(binding = 0) uniform sampler2D tex0;

#if TEXTURE_COUNT > 1
layout(binding = 1) uniform sampler2D tex1;
#endif

#if TEXTURE_COUNT > 2
layout(binding = 2) uniform sampler2D tex2;
#endif

#if TEXTURE_COUNT > 3
layout(binding = 3) uniform sampler2D tex3;
#endif

#if TEXTURE_COUNT > 4
layout(binding = 4) uniform sampler2D tex4;
#endif

#if TEXTURE_COUNT > 5
layout(binding = 5) uniform sampler2D tex5;
#endif


void main()
{
    o_Color = vec4(InOut.texCoord.x, InOut.texCoord.y, 1.0f, 1.0f);

    o_Color += texture(tex0, InOut.texCoord);

#if TEXTURE_COUNT > 1
    o_Color += texture(tex1, InOut.texCoord);
#endif

#if TEXTURE_COUNT > 2
    o_Color += texture(tex2, InOut.texCoord);
#endif

#if TEXTURE_COUNT > 3
    o_Color += texture(tex3, InOut.texCoord);
#endif

#if TEXTURE_COUNT > 4
    o_Color += texture(tex4, InOut.texCoord);
#endif

#if TEXTURE_COUNT > 5
    o_Color += texture(tex5, InOut.texCoord);
#endif
}

#endif
