﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "gfxUtilAgingTest_ValidationResultData.h"

namespace nnt { namespace gfx { namespace util { namespace agingtest {


ValidationResultData::ValidationResultData()
: runCount(0)
, totalMiss(0)
, missOver(0)
, missBelow(0)
, hasFailed(false)
{
}

ValidationResultData::~ValidationResultData()
{
}

void ValidationResultData::Clear()
{
    runCount = 0;
    totalMiss = 0;
    missOver = 0;
    missBelow = 0;
    hasFailed = false;
}

void ValidationResultData::Update(ValidationResult result)
{
    runCount++;

    if (result != ValidationResult_Pass)
    {
        totalMiss++;

        if (result == ValidationResult_MissOver)
            missOver++;
        else if (result == ValidationResult_MissBelow)
            missBelow++;
        else
            NN_ABORT();
    }
    NN_ASSERT((missOver + missBelow) == totalMiss);
}

bool ValidationResultData::UpdateIsFailed(double failureThresold)
{
    if (!hasFailed)
    {
        double failureRate = ComputeFailureRate();
        if (failureRate > failureThresold)
        {
            NN_LOG("Set failure %d [%d, %d] / %d\n", totalMiss, missOver, missBelow, runCount);
            hasFailed = true;
        }
    }

    return hasFailed;
}


} } } } // namespace nnt { namespace gfx { namespace util { namespace agingtest {
