﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// Particle mode.
enum PARTICLE_MODE
{
    SNOW,
    SAKURA,
    MIST,
};

// Maximum number of particles.
extern const u32 MAX_PARTICLE;

// Number of particles to be drawn.
extern u32 currentParticleNum;

// Current loop time.
extern f32 currentLoop;
// Loop length.
extern f32 loopLength;

void InitParticle();

// Increase/decrease number of particles to be drawn.
u32 AddParticle(s32 adder);
// Update particle.
void UpdateParticle(f32 frameTime);
