/*---------------------------------------------------------------------------*

  Copyright 2010-2011 Nintendo.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

 *---------------------------------------------------------------------------*/
// index bit assignment:
// MSB
// position x offset: 12
// position y offset: 5
// texcoord x value:  8
// texcoord y value:  7
// LSB

uniform Vin {
	vec4 u_BasePosition;
	vec2 u_Scale;
};

varying vec2 v_TexCoord;

void main()
{
    gl_Position = vec4((u_BasePosition.x + (gl_VertexID >> 20)) * u_Scale.x - 1,
                       (u_BasePosition.y + ((gl_VertexID >> 15) & 0x1f)) * u_Scale.y + 1,
                       u_BasePosition.z,
                       1.0);
    v_TexCoord = vec2(((gl_VertexID >> 7) & 0xff)/255.0,
                      ((gl_VertexID >> 0) & 0x7f)/127.0);
}

