﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/*---------------------------------------------------------------------------*
 * Includes
 *---------------------------------------------------------------------------*/

static const int AVX_FRAME_SIZE_SAMPLES =   160;          // 160 stereo samples @ 32KHz
static const int AVX_FRAME_SIZE_WORDS =     (160 * 2);    // 2 words per stereo sample
static const int AVX_FRAME_SIZE_BYTES =     (160 * 2 * 2);// 2 bytes per sample, 2 channels

/// \brief Initializes AVX
///
/// \param left AVX left buffer
/// \param right AVX right buffer
/// \param size AVX buffer size
///
void    DEMOAVXInit             (s16 *left, s16 *right, u32 size);

/// \brief Refreshes AVX Buffer
///
/// \param start_index Pointer to save starting position in final sample buffer
/// \param end_index Pointer to save ending position in final sample buffer
///
/// \retval Number of frames filled * AVX_FRAME_SIZE_SAMPLES
u32     DEMOAVXRefreshBuffer    (u32 *start_index, u32 *end_index);

/// \brief Clears buffer and attaches AVX interrupt handler
///
/// \param buffer Buffer to clear and use
/// \param num_frames Number of frames in buffer
///
void    DEMOAVXAttach           (void *buffer, u32 num_frames);

/// \brief Gets current audio frame index
///
/// \retval Current frame index
u32     DEMOAVXGetFrameCounter  (void);

/// \brief Gets number of frames filled since last user refresh
///
/// \retval Number of frames filled
u32     DEMOAVXGetNumFilled     (void);
