﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "testG3d_ViewerTestAllocator.h"
#include <cstdlib>
#include <nn/g3d/g3d_ResFile.h>

namespace G3dTest{
    size_t GetResFileAlignment(const char* path, G3dTest::ViewerTestAllocator& allocator);
    nn::g3d::ResFile* LoadResFile(const char* path, nn::gfx::Device& device, G3dTest::ViewerTestAllocator& allocator);
    void* LoadFile(const char* path, ViewerTestAllocator& allocator, size_t* pSize, size_t alignment);
    void FreeFile(void* pFileBuffer, ViewerTestAllocator& allocator);
    bool Exists(const char* path);
}
