﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include <nn/mii.h>
#include <nn/g3d/g3d_Mii.h>

//!< nn::mii::AssignCharModel() をコールするために必要十分な情報を保持します。
//!< これらの情報はアクセサを通してセットされます。
class G3dMiiCharModelBase
{
public:
    G3dMiiCharModelBase()
        : m_pResModel()
        , m_pCharModel()
        , m_pMaterialCallback()
        , m_pDrawParamCallback()
        , m_pDrawParamCallbackParam()
    {
    }

    virtual ~G3dMiiCharModelBase()
    {
        m_pResModel = nullptr;
        m_pCharModel = nullptr;
        m_pMaterialCallback = nullptr;
        m_pMaterialCallbackParam = nullptr;
        m_pDrawParamCallback = nullptr;
        m_pDrawParamCallbackParam = nullptr;
    }

    virtual void Initialize()
    {
    }

    //!< 本クラスの Finalize() は保持しているポインタをリセットするだけです。
    //!< 破棄はこれらを与えたクラスに実装して下さい。
    //!< リソースは protected なので子クラスから自由にアクセス可能です。
    virtual void Finalize()
    {
        m_pResModel = nullptr;
        m_pCharModel = nullptr;
        m_pMaterialCallback = nullptr;
        m_pMaterialCallbackParam = nullptr;
        m_pDrawParamCallback = nullptr;
        m_pDrawParamCallbackParam = nullptr;
    }

    void AssignCharModel()
    {
        NN_ASSERT_NOT_NULL( m_pResModel );
        NN_ASSERT_NOT_NULL( m_pCharModel );
        NN_ASSERT( m_pCharModel->IsInitialized() );
        NN_ASSERT_NOT_NULL( m_pMaterialCallback );
        NN_ASSERT_NOT_NULL( m_pDrawParamCallback );
        nn::g3d::mii::AssignCharModel( m_pResModel, m_pCharModel, *m_pMaterialCallback, m_pMaterialCallbackParam, *m_pDrawParamCallback, m_pDrawParamCallbackParam );
    }

    void SetResModel( nn::g3d::ResModel* pResModel )
    {
        m_pResModel = pResModel;
    }

    void SetCharModel( nn::mii::CharModel* pCharModel )
    {
        m_pCharModel = pCharModel;
    }

    void SetMaterialCallback( nn::g3d::mii::MaterialCallbackType pCb )
    {
        m_pMaterialCallback = pCb;
    }

    void SetMaterialCallbackParam( void* pCbParam )
    {
        m_pMaterialCallbackParam = pCbParam;
    }

    void SetDrawParamCallback( nn::g3d::mii::DrawParamCallbackType pCb )
    {
        m_pDrawParamCallback = pCb;
    }

    void SetDrawParamCallbackParam( void* pCbParam )
    {
        m_pDrawParamCallbackParam = pCbParam;
    }


    nn::g3d::mii::MaterialCallbackType GetMaterialCallback()
    {
        return m_pMaterialCallback;
    }

    void* GetMaterialCallbackParam()
    {
        return m_pMaterialCallbackParam;
    }

    nn::g3d::mii::DrawParamCallbackType GetDrawParamCallback()
    {
        return m_pDrawParamCallback;
    }

    void* GetDrawParamCallbackParam()
    {
        return m_pDrawParamCallbackParam;
    }

protected:
    nn::g3d::ResModel*                       m_pResModel;
    nn::mii::CharModel*                      m_pCharModel;
    nn::g3d::mii::MaterialCallbackType       m_pMaterialCallback;
    void*                                    m_pMaterialCallbackParam;
    nn::g3d::mii::DrawParamCallbackType      m_pDrawParamCallback;
    void*                                    m_pDrawParamCallbackParam;
};
