﻿# 指定されたマテリアルの指定された id を持つシェーダーアサインを指定された値に書き換えます。
def Filter(target):
    args = ScriptArgument.split(",");
    if len(args) < 3:
        print("対象のマテリアル名、シェーダーアサインの id、書き換え後の値の順番にカンマ区切りで --argument に指定してください。すべてのマテリアルを対象とする場合はマテリアル名に All を指定してください。");
        Result = False;
        return;

    target_material = args[0].strip();
    target_id = args[1].strip();
    value = args[2].strip();
    
    if target_material == "All":
        EditMaterial(target.Document, target_id, value);
    else:
        for mat in target.Document.SelectNodes("//material"):
            if mat.GetAttribute("name") == target_material:
                EditMaterial(mat, target_id, value);
                break;

    target.Write()

def EditMaterial(target_node, target_id, value):
    for shader_param in target_node.SelectNodes(".//shader_param"):
        if shader_param.GetAttribute("id") == target_id:
            shader_param.InnerText = value;
     
    for sampler_assign in target_node.SelectNodes(".//sampler_assign"):
        if sampler_assign.GetAttribute("id") == target_id:
            sampler_assign.SetAttribute("sampler_name", value);
     
    for shader_option in target_node.SelectNodes(".//shader_option"):
        if shader_option.GetAttribute("id") == target_id:
            shader_option.SetAttribute("value", value);
     
    for render_info in target_node.SelectNodes(".//render_info"):
        if render_info.GetAttribute("name") == target_id:
            render_info.InnerText = value;


