$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)
$g3dDemoSamplePath   = $scriptDirectoryPath + "\..\..\..\..\..\..\..\Samples\Sources\Applications\G3dDemo"
$csprojPath          = $g3dDemoSamplePath + "\ConvertDemoResources-spec.Generic.csproj"
$msbuild             = $env:VS140COMNTOOLS + "..\..\..\MSBuild\14.0\Bin\MSBuild.exe"
$targetName          = $Args[0]
$buildType           = $Args[1]
$srcDirectoryPath    = $g3dDemoSamplePath + "\TempResources"
$dstDirectoryPath    = $scriptDirectoryPath + "\..\..\..\..\..\..\..\Tests\Outputs\" + $targetName + "\Tests\testG3d_ScreenCaptureDemo\" + $buildType + "\Contents"
$platform            = "Win32"
$copyFileArray = @("Duck.bfres",
                   "FemaleA.bfres",
                   "Fish.bfres",
                   "Light.bfres",
                   "MaleA.bfres",
                   "Shared.bntx",
                   "WhiteTown_Water_Caustics.bfres",
                   "WhiteTown_Water_Flat.bfres",
                   "bg_WhiteTown.bfres",
                   "town_env.bfres",
                   "shader\demo.bfsha",
                   "shader\gbuffer.bfsha",
                   "shader\outline.bfsha",
                   "shader\shadow.bfsha",
                   "shader\tex_average.bfsha",
                   "shader\town.bfsha")

if($targetName.Contains("Win32")){
    $srcDirectoryPath = $srcDirectoryPath + "\Win32-v140"
}elseif($targetName.Contains("x64")){
    $srcDirectoryPath = $srcDirectoryPath + "\x64-v140"
    $platform="x64"
}else{
    exit 1
}

Try{
    # msbuild̃pXǉB
    $env:Path = $env:VS140COMNTOOLS + "..\..\..\MSBuild\14.0\Bin;" + $env:Path
    msbuild $csprojPath /p:Configuration=VS2015_Release /p:Platform=$platform
    foreach($file in $copyFileArray)
    {
        $srcFile = $srcDirectoryPath + "\" + $file
        $dstFile = $dstDirectoryPath + "\" + $file
        echo F | xcopy $srcFile $dstFile /R /Y
    }
}Catch{
    echo ERROR:msbuild̓t@CRs[ɃG[܂
    exit 1
}
