﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fs/fs_Result.h>
#include <nnt/graphics/testGraphics_Path.h>

namespace nnt{ namespace eft{

    // 指定したパスと祖先のディレクトリをすべて作成します。
    // すべてのディレクトリの作成に成功するか、既にディレクトリが存在している場合成功を返します。
    // それ以外の場合、エラーの値を返します。
    nn::Result CreateDirectories(const char* path);
    // 指定したパスと祖先のディレクトリをすべて作成します。
    // すべてのディレクトリの作成に成功するか、既にディレクトリが存在している場合成功を返します。
    // それ以外の場合、エラーの値を返します。
    nn::Result CreateDirectories(const nnt::graphics::Path* path);
    // 指定したパスと祖先のディレクトリをすべて作成します。
    // すべてのディレクトリの作成に成功するか、既にディレクトリが存在している場合成功を返します。
    // それ以外の場合、エラーの値を返します。
    nn::Result CreateDirectories(const nnt::graphics::Path& path);

}}
