﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <filesystem>
#include <vector>

class PathUtility
{
public:
    //---------------------------------------------------------------------------
    //! @brief 前後の余分な空白文字を取り除く
    //---------------------------------------------------------------------------
    static std::string Trim(const std::string& string, const char* trimCharacterList);

    //---------------------------------------------------------------------------
    //! @brief 分割
    //---------------------------------------------------------------------------
    static std::vector<std::string> Sprit(const std::string &str, char sep);

    //---------------------------------------------------------------------------
    //! @brief 相対パスから絶対パスを取得する
    //---------------------------------------------------------------------------
    static std::string GetAbsolutePath(std::string basePath, std::string relativePath);

    //---------------------------------------------------------------------------
    //! @brief 絶対パスから相対パスを取得します
    //---------------------------------------------------------------------------
    static std::string GetRelativePath(std::string basePath, std::string absolutePath);

    //---------------------------------------------------------------------------
    //! @brief カレントディレクトリを基点に相対パスを取得
    //---------------------------------------------------------------------------
    static std::string GetAbsolutePathFromCurrentDirectory(char* path);

    //---------------------------------------------------------------------------
    //! @brief カレントディレクトリを基点に相対ファイルパスを取得
    //---------------------------------------------------------------------------
    static std::string GetFilePathFromCurrentDirectory(char* path);

};





