﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/eft/typeDef2.h>
#include <nw/eft/eft2_Heap.h>


//------------------------------------------------------------------------------
//! @brief  ファイルマネージャです。
//------------------------------------------------------------------------------
class FileManager
{
public:
    //---------------------------------------------------------------------------
    //! @brief  唯一のインスタンスを取得します。
    //!
    //! @return インスタンスを返します。
    //---------------------------------------------------------------------------
    static FileManager& GetInstance();

    //---------------------------------------------------------------------------
    //! @brief  ヒープを設定します。
    //!
    //! @param[in] pHeap ヒープ
    //---------------------------------------------------------------------------
    void SetHeap( nw::eft2::Heap* pHeap );

    //!------------------------------------------------------------------------------
    //! @brief  データをファイルから読み込みます。
    //!
    //! @param[in]  pPath  ファイルパス
    //! @param[out] ppData データ
    //! @param[out] pSize  データサイズ
    //! @return 読み込んだデータを返します。
    //!         このデータが不要になったときはReleaseData関数を仕様してデータを破棄してください。
    //!------------------------------------------------------------------------------
    bool ReadFile ( const char* pPath, u8** ppData, u32* pSize );

    //!------------------------------------------------------------------------------
    //! @brief  ファイルから読み込んだデータを破棄します。
    //!
    //! @return pData データ
    //!------------------------------------------------------------------------------
    void ReleaseData ( u8* pData );

    //!------------------------------------------------------------------------------
    //! @brief  データをファイルに保存します。
    //!
    //! @param[in] pData データ
    //! @param[in] size  データサイズ
    //! @param[in] pPath ファイルパス
    //!------------------------------------------------------------------------------
    bool WriteFile( const u8* pData, u32 size, const char* pPath );

private:
    nw::eft2::Heap* m_pHeap;  //! ヒープ
};
