﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/eft/typeDef2.h>

#include "nwDemo/FrameBuffer.h"
#include "nwUtil/TestHeap.h"


//---------------------------------------------------------------------------
//! @brief  スクリーンキャプチャです。
//---------------------------------------------------------------------------
class ScreenCapture
{
public:
    //---------------------------------------------------------------------------
    //! @brief  コンストラクタです。
    //!
    //! @param[in] pFrameBuffer フレームバッファ
    //---------------------------------------------------------------------------
    ScreenCapture();

    //---------------------------------------------------------------------------
    //! @brief  デストラクタです。
    //---------------------------------------------------------------------------
    ~ScreenCapture();

    //---------------------------------------------------------------------------
    //! @brief  初期化処理です。
    //!
    //! @param[in] pHeap        ヒープ
    //! @param[in] pFrameBuffer フレームバッファ (R8G8B8A8)
    //---------------------------------------------------------------------------
    void Initialize( TestHeap* pHeap, nw::eftdemo::FrameBuffer* pFrameBuffer );

    //---------------------------------------------------------------------------
    //! @brief  破棄処理です。
    //---------------------------------------------------------------------------
    void Release();

    //---------------------------------------------------------------------------
    //! @brief  キャプチャを行います。
    //---------------------------------------------------------------------------
    void Capture();

    //---------------------------------------------------------------------------
    //! @brief  キャプチャ画像の横幅を取得します。
    //!
    //! @return キャプチャ画像の横幅を返します。
    //---------------------------------------------------------------------------
    int GetWidth() const;

    //---------------------------------------------------------------------------
    //! @brief  キャプチャ画像の縦幅を取得します。
    //!
    //! @return キャプチャ画像の縦幅を返します。
    //---------------------------------------------------------------------------
    int GetHeight() const;

    //---------------------------------------------------------------------------
    //! @brief  ピクセルデータを取得します。
    //!         ピクセルデータの形式はR8G8B8A8です。
    //!
    //! @return ピクセルデータを返します。
    //---------------------------------------------------------------------------
    const u8* GetPixels() const;

private:
    TestHeap*                 m_pHeap;         //!< ヒープ
    nw::eftdemo::FrameBuffer* m_pFrameBuffer;  //!< フレームバッファ

    int                       m_width;         //!< キャプチャ画像の横幅
    int                       m_height;        //!< キャプチャ画像の縦幅

    u8*                       m_pRgbPixels;    //!< RGBデータ

#if EFT_IS_CAFE
    u8*                       m_pColorConvertPixels;   //!< 色変換ピクセルデータ
    GX2ColorBuffer*           m_pColorConvertBuffer;   //!< 色変換バッファ

    u8*                       m_pTilingConvertPixels;  //!< タイリング変換ピクセルデータ
    GX2ColorBuffer*           m_pTilingConvertBuffer;  //!< タイリング変換バッファ
#endif
};
