﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>

namespace nnt{ namespace graphics{

    struct ImageInformation
    {
        //! 画像の横方向のピクセル数。
        //! 0 より大きな値を指定します。
        int width;
        //! 画像の縦方向のピクセル数。
        //! 0 より大きな値を指定します。
        int height;
        //! 1ピクセルあたりのチャンネル数。
        //! 0 より大きな値を指定します。
        int nChannels;
        //! 1チャンネルあたりのバイト数。
        //! 0 より大きな値を指定します。
        int channelSize;
        //! 1ピクセルあたりのバイト数。
        //! channelSize * nChannels 以上の値を指定します。
        int pixelPitch;
        //! 画像の1ラインあたりのバイト数。
        //! pixelPitch * width 以上の値を指定します。
        int stride;
        //! 画像のデータへのポインタ
        void* pData;
        //! 画像のデータのサイズ。
        //! stride * height 以上の値を指定します。
        int dataSize;

        //! RGB の各チャンネルが 8bit 整数で表現される画像として初期化します。
        //! パディングはなしとして設定されます。
        void SetDefaultR8_G8_B8(void* pData, int dataSize, int width, int height) NN_NOEXCEPT;
        //! RGBA の各チャンネルが 8bit 整数で表現される画像として初期化します。
        //! パディングはなしとして設定されます。
        void SetDefaultR8_G8_B8_A8(void* pData, int dataSize, int width, int height) NN_NOEXCEPT;
    };

}}
