﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testGraphics_ImageInformation.h"

namespace nnt{ namespace graphics{

    void ImageInformation::SetDefaultR8_G8_B8(void* data, int size, int dataWidth, int dataHeight) NN_NOEXCEPT
    {
        this->width       = dataWidth;
        this->height      = dataHeight;
        this->nChannels   = 3;
        this->channelSize = 1;
        this->pixelPitch  = this->nChannels * this->channelSize;
        this->stride      = this->pixelPitch * this->width;
        this->pData       = data;
        this->dataSize    = size;
    }

    void ImageInformation::SetDefaultR8_G8_B8_A8(void* data, int size, int dataWidth, int dataHeight) NN_NOEXCEPT
    {
        this->width       = dataWidth;
        this->height      = dataHeight;
        this->nChannels   = 4;
        this->channelSize = 1;
        this->pixelPitch  = this->nChannels * this->channelSize;
        this->stride      = this->pixelPitch * this->width;
        this->pData       = data;
        this->dataSize    = size;
    }

}}
