﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testGc_Unit_GcLibrary_Util.h"


void TESTOUT(bool flag, const char* str) NN_NOEXCEPT
{
    NN_LOG("%s: %s\n", flag ? "OK" : "NG", str);
    ASSERT_TRUE(flag);
}

void TESTCMP(char* a, char* b, size_t length, std::string str) NN_NOEXCEPT
{
    TESTOUT(memcmp(a, b, length) == 0, str.c_str());
}

void TESTCMP_NE(char* a, char* b, size_t length, std::string str) NN_NOEXCEPT
{
    TESTOUT(memcmp(a, b, length) != 0, str.c_str());
}

void PrintArray(const char* buffer, const size_t bufferLength) NN_NOEXCEPT
{
    for (size_t i = 0; i<bufferLength; i++)
    {
        if (i != 0 && i % 16 == 0)
        {
            NN_LOG("\n");
        }

        NN_LOG("%02X ", buffer[i]);
    }
    NN_LOG("\n");
}
