﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once


// ※順序に意味あり
typedef enum {
    AsicSessionState_Initial,
    AsicSessionState_Establishing,
    AsicSessionState_Established,
    AsicSessionState_ReEstablishing,
} AsicSessionState;

// ※順序に意味あり
typedef enum {
    GameCardState_NotInserted,
    GameCardState_Inserted,
    GameCardState_Normal,
    GameCardState_Secure,
    GameCardState_Debug,
} GameCardState;

typedef enum {
    GcAction_None,
    GcAction_Wait,
    GcAction_Wait2,
    GcAction_Wait3,
    GcAction_InsertCard,
    GcAction_RemoveCard,
    GcAction_InsertCardWait,
    GcAction_RemoveCardWait,
    GcAction_Activate,
    GcAction_Deactivate,
    GcAction_ChangeSecure,
    GcAction_PutToSleep,
    GcAction_Awaken,
    GcAction_Read,
    GcAction_ReadNormal,
    GcAction_ReadSecure,
} GcAction;

void CheckStateAndActionResult(AsicSessionState preAsicState, GameCardState preCardState, GcAction action, AsicSessionState expectedAsicState, GameCardState expectedCardState, bool isFailTest);
void CheckStateAndActionResult(AsicSessionState preAsicState, GameCardState preCardState, GcAction* actionList, int actionListLength, AsicSessionState expectedAsicState, GameCardState expectedCardState, bool isFailTest);

class GcTest : public ::testing::Test
{
    static bool m_isLogOutputEnable;

public:
    virtual void SetUp() override;
    virtual void TearDown() override;
    static void DisableOutputLog()
    {
        m_isLogOutputEnable = false;
    }
};

