﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstring>
#include <nn/fs/fs_Directory.h>
#include <nn/fs/fsa/fs_IFile.h>
#include <nn/fs/fsa/fs_IDirectory.h>
#include <nn/fs/fsa/fs_IFileSystem.h>
#include <nn/fs/fs_IStorage.h>
#include <nn/fs/detail/fs_Newable.h>

using namespace nn::fs::detail;
using namespace nn::fssystem;

namespace nn { namespace fs { namespace detail {

    // Dummy Instance
    class DummyFile : public Newable, public fsa::IFile
    {
    public:
        DummyFile(const char* path, OpenMode mode) NN_NOEXCEPT : m_mode(mode)
        {
            strncpy(m_path, path, EntryNameLengthMax);
        }
        virtual Result DoRead(size_t* outValue, int64_t offset, void* buffer, size_t size, const ReadOption& option) NN_NOEXCEPT NN_OVERRIDE
        {
            NN_UNUSED(outValue);
            NN_UNUSED(offset);
            NN_UNUSED(buffer);
            NN_UNUSED(size);
            NN_UNUSED(option);
            NN_RESULT_SUCCESS;
        }
        virtual Result DoWrite(int64_t offset, const void* buffer, size_t size, const WriteOption& option) NN_NOEXCEPT NN_OVERRIDE
        {
            NN_UNUSED(offset);
            NN_UNUSED(buffer);
            NN_UNUSED(size);
            NN_UNUSED(option);
            NN_RESULT_SUCCESS;
        }
        virtual Result DoFlush() NN_NOEXCEPT NN_OVERRIDE
        {
            NN_RESULT_SUCCESS;
        }
        virtual Result DoSetSize(int64_t size) NN_NOEXCEPT NN_OVERRIDE
        {
            NN_UNUSED(size);
            NN_RESULT_SUCCESS;
        }
        virtual Result DoGetSize(int64_t* outValue) NN_NOEXCEPT NN_OVERRIDE
        {
            NN_UNUSED(outValue);
            NN_RESULT_SUCCESS;
        }
        virtual Result DoOperateRange(
            void* outBuffer,
            size_t outBufferSize,
            OperationId operationId,
            int64_t offset,
            int64_t size,
            const void* inBuffer,
            size_t inBufferSize) NN_NOEXCEPT NN_OVERRIDE
        {
            NN_UNUSED(outBuffer);
            NN_UNUSED(outBufferSize);
            NN_UNUSED(operationId);
            NN_UNUSED(offset);
            NN_UNUSED(size);
            NN_UNUSED(inBuffer);
            NN_UNUSED(inBufferSize);
            NN_RESULT_SUCCESS;
        }
        char m_path[EntryNameLengthMax];
        OpenMode m_mode;
    };

    class DummyDirectory : public Newable, public fsa::IDirectory
    {
    public:
        explicit DummyDirectory(const char* path) NN_NOEXCEPT
        {
            strncpy(m_path, path, EntryNameLengthMax);
        }
        virtual Result DoRead(int64_t* outValue, DirectoryEntry* outEntries, int64_t count) NN_NOEXCEPT NN_OVERRIDE
        {
            NN_UNUSED(outValue);
            NN_UNUSED(outEntries);
            NN_UNUSED(count);
            NN_RESULT_SUCCESS;
        }
        virtual Result DoGetEntryCount(int64_t* outValue) NN_NOEXCEPT NN_OVERRIDE
        {
            NN_UNUSED(outValue);
            NN_RESULT_SUCCESS;
        }
        char m_path[EntryNameLengthMax];
    };

    class DummyStorage : public Newable, public IStorage
    {
    public:
        explicit DummyStorage(bool* pIsDestructed) NN_NOEXCEPT : m_pIsDestructed(pIsDestructed), m_index(-1)
        {
        }
        explicit DummyStorage(int index) NN_NOEXCEPT : m_pIsDestructed(nullptr), m_index(index)
        {
        }
        virtual ~DummyStorage() NN_NOEXCEPT NN_OVERRIDE
        {
            if (m_pIsDestructed != nullptr)
            {
                *m_pIsDestructed = true;
            }
        }
        virtual Result Read(int64_t offset, void* buffer, size_t size) NN_NOEXCEPT NN_OVERRIDE
        {
            NN_UNUSED(offset);
            NN_UNUSED(buffer);
            NN_UNUSED(size);
            NN_RESULT_SUCCESS;
        }
        virtual Result Flush() NN_NOEXCEPT NN_OVERRIDE
        {
            NN_RESULT_SUCCESS;
        }
        virtual Result GetSize(int64_t* outValue) NN_NOEXCEPT NN_OVERRIDE
        {
            NN_UNUSED(outValue);
            NN_RESULT_SUCCESS;
        }
        int m_index;
    private:
        bool* m_pIsDestructed;
    };

    class DummyFileSystem : public Newable, public fsa::IFileSystem
    {
    public:
        explicit DummyFileSystem(bool* pIsDestructed) NN_NOEXCEPT : m_pIsDestructed(pIsDestructed)
        {
        }
        virtual ~DummyFileSystem() NN_NOEXCEPT NN_OVERRIDE
        {
            *m_pIsDestructed = true;
        }
        virtual Result DoCreateFile(const char* path, int64_t size, int option) NN_NOEXCEPT NN_OVERRIDE
        {
            NN_UNUSED(path);
            NN_UNUSED(size);
            NN_UNUSED(option);
            NN_RESULT_SUCCESS;
        }
        virtual Result DoDeleteFile(const char* path) NN_NOEXCEPT NN_OVERRIDE
        {
            NN_UNUSED(path);
            NN_RESULT_SUCCESS;
        }
        virtual Result DoCreateDirectory(const char* path) NN_NOEXCEPT NN_OVERRIDE
        {
            NN_UNUSED(path);
            NN_RESULT_SUCCESS;
        }
        virtual Result DoDeleteDirectory(const char* path) NN_NOEXCEPT NN_OVERRIDE
        {
            NN_UNUSED(path);
            NN_RESULT_SUCCESS;
        }
        virtual Result DoDeleteDirectoryRecursively(const char* path) NN_NOEXCEPT NN_OVERRIDE
        {
            NN_UNUSED(path);
            NN_RESULT_SUCCESS;
        }
        virtual Result DoCleanDirectoryRecursively(const char* path) NN_NOEXCEPT NN_OVERRIDE
        {
            NN_UNUSED(path);
            NN_RESULT_SUCCESS;
        }
        virtual Result DoRenameFile(const char* currentPath, const char* newPath) NN_NOEXCEPT NN_OVERRIDE
        {
            NN_UNUSED(currentPath);
            NN_UNUSED(newPath);
            NN_RESULT_SUCCESS;
        }
        virtual Result DoRenameDirectory(const char* currentPath, const char* newPath) NN_NOEXCEPT NN_OVERRIDE
        {
            NN_UNUSED(currentPath);
            NN_UNUSED(newPath);
            NN_RESULT_SUCCESS;
        }
        virtual Result DoGetEntryType(DirectoryEntryType* outValue, const char* path) NN_NOEXCEPT NN_OVERRIDE
        {
            NN_UNUSED(outValue);
            NN_UNUSED(path);
            NN_RESULT_SUCCESS;
        }
        virtual Result DoOpenFile(std::unique_ptr<fsa::IFile>* outValue, const char* path, OpenMode mode) NN_NOEXCEPT NN_OVERRIDE
        {
            if (strncmp(path, "DummyFile", 9) != 0)
            {
                return ResultPathNotFound();
            }
            std::unique_ptr<fsa::IFile> file(new DummyFile(path, mode));
            if (!file)
            {
                return ResultAllocationMemoryFailed();
            }
            *outValue = std::move(file);
            NN_RESULT_SUCCESS;
        }
        virtual Result DoOpenDirectory(std::unique_ptr<fsa::IDirectory>* outValue, const char* path, OpenDirectoryMode mode) NN_NOEXCEPT NN_OVERRIDE
        {
            NN_UNUSED(mode);
            if (strncmp(path, "DummyDir", 8) != 0)
            {
                return ResultPathNotFound();
            }
            std::unique_ptr<fsa::IDirectory> directory(new DummyDirectory(path));
            if (!directory)
            {
                return ResultAllocationMemoryFailed();
            }
            *outValue = std::move(directory);
            NN_RESULT_SUCCESS;
        }
        Result OpenStorage(std::unique_ptr<IStorage>* outValue, int index) NN_NOEXCEPT
        {
            std::unique_ptr<IStorage> storage(new DummyStorage(index));
            if (!storage)
            {
                return ResultAllocationMemoryFailed();
            }
            *outValue = std::move(storage);
            NN_RESULT_SUCCESS;
        }
    private:
        bool* m_pIsDestructed;
    };

    // Dummy FileSystemComponentManager

    // Dummy FileSystemComponentCreator
}}}
