﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "testFs_Stress_TestContext.h"

class StressTestMountSaveData : public StressTestMountInfoBase
{
public:
    StressTestMountSaveData() NN_NOEXCEPT
    {
    }

    virtual ~StressTestMountSaveData() NN_NOEXCEPT NN_OVERRIDE
    {
    }

    //! マウント
    void Mount() NN_NOEXCEPT
    {
#ifdef NN_BUILD_CONFIG_OS_WIN
        NNT_ASSERT_RESULT_SUCCESS(
            nn::fs::MountSaveData(
                GetMountName(),
                StressTestParam::ApplicationIds[0],
                StressTestParam::UserIds[0]
            )
        );
#else
        NNT_ASSERT_RESULT_SUCCESS(
            nn::fs::MountSaveData(
                GetMountName(),
                StressTestParam::UserIds[0]
            )
        );
#endif
    }

    //! アンマウント
    void Unmount() NN_NOEXCEPT
    {
        nn::fs::Unmount(GetMountName());
    }

    //! セーブデータかどうかを取得 (コミット操作判定で使用)
    virtual bool IsSaveData() const NN_NOEXCEPT NN_OVERRIDE
    {
        return true;
    }

    //! アプリケーションIDを取得
    virtual uint64_t GetApplicationId() const NN_NOEXCEPT NN_OVERRIDE
    {
        return StressTestParam::OwnerIds[0];
    }

    //! ユーザーIDを取得
    virtual nn::fs::UserId GetUserId() const NN_NOEXCEPT NN_OVERRIDE
    {
        return StressTestParam::UserIds[0];
    }
};
