﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testFs_Stress_OpenEntriesTestCase.h"

namespace nnt { namespace fs {

NN_DEFINE_STATIC_CONSTANT(const int OpenEntriesTestCase::PathLength);

OpenEntriesTestCase::OpenEntriesTestCase(
    int threadCount,
    int entryCount,
    nn::fs::DirectoryEntryType entryType) NN_NOEXCEPT
    : m_EntryType(entryType),
      m_ThreadCount(threadCount),
      m_EntryCount(entryCount)
{
}

OpenEntriesTestCase::~OpenEntriesTestCase() NN_NOEXCEPT
{
}

int OpenEntriesTestCase::GetThreadCount() const NN_NOEXCEPT
{
    return m_ThreadCount;
}

void OpenEntriesTestCase::SetUp(FsStressTest* pTest) NN_NOEXCEPT
{
    FailAll();
    for( auto threadIndex = 0; threadIndex < GetThreadCount(); ++threadIndex )
    {
        for( auto entryIndex = 0; entryIndex < GetEntryCount(); ++entryIndex )
        {
            char path[PathLength];
            MakePath(path, GetEntryIndex(threadIndex, entryIndex));
            if( pTest->IsReadOnly(GetTestCaseIndex()) )
            {
                // エントリの存在を確認する
                nn::fs::DirectoryEntryType type;
                NNT_ASSERT_RESULT_SUCCESS(nn::fs::GetEntryType(&type, path));
                ASSERT_EQ(m_EntryType, type);
            }
            else
            {
                // エントリを作成する
                const auto result = m_EntryType == nn::fs::DirectoryEntryType_Directory
                    ? nn::fs::CreateDirectory(path)
                    : nn::fs::CreateFile(path, 0);
                if( !nn::fs::ResultPathAlreadyExists::Includes(result) )
                {
                    NNT_ASSERT_RESULT_SUCCESS(result);
                }
            }
        }
    }
    SucceedAll();
}

void OpenEntriesTestCase::TearDown(FsStressTest* pTest) NN_NOEXCEPT
{
    if( !pTest->IsReadOnly(GetTestCaseIndex()) )
    {
        // エントリを削除する
        for( auto threadIndex = 0; threadIndex < GetThreadCount(); ++threadIndex )
        {
            for( auto entryIndex = 0; entryIndex < GetEntryCount(); ++entryIndex )
            {
                char path[PathLength];
                MakePath(path, GetEntryIndex(threadIndex, entryIndex));
                const auto result = m_EntryType == nn::fs::DirectoryEntryType_Directory
                    ? nn::fs::DeleteDirectoryRecursively(path)
                    : nn::fs::DeleteFile(path);
                if( !nn::fs::ResultPathNotFound::Includes(result) )
                {
                    NNT_ASSERT_RESULT_SUCCESS(result);
                }
            }
        }
    }
}

}}
