﻿# coding: UTF-8

import os
import random
import subprocess
import xml.dom.minidom
import sys
import time
import testpath
import romfs
import makerom
import execute

print testpath.SIGLO_ROOT

def printInfo(s):
    print s
    sys.stdout.flush()

def outputLog(s):
    with open(testpath.PATCH_SIZE_LOG_FILE_PATH, 'a+') as outputFile:
        outputFile.writelines(s + '\n')

def setup():
    random.seed(0)

def main():
    setup()

    platform = 'NX-NXFP2-a64'
    buildType = 'Develop'
    fileType = 'zero'
    fileSize = 4 * 1024 * 1024

    argv = sys.argv
    if len(argv) >= 4:
        platform = argv[1]
        buildType = argv[2]
        if platform.startswith('NXFP2-a'):
            platform = 'NX-' + platform # NXFP2-aXX → NX-NXFP2-aXX
        fileType = argv[3]

    outputDirectoryPath = os.path.normpath(testpath.SIGLO_ROOT + '/Tests/Outputs/' + platform + '/Tests/testFs_RomFsOptimizedPatch/' + buildType)

    if os.path.exists(testpath.TEST_PATH) == False:
        os.makedirs(testpath.TEST_PATH)
    with open(testpath.PATCH_SIZE_LOG_FILE_PATH, 'w') as outputFile:
        outputFile.writelines('RomFsOptimizedPatchTestLog\n\n')

    romfs.createMountText()

    romfs.cleanRomFs()
    romsize = romfs.createRomFs()

    # ---
    # 差分無しテスト
    # v0
    printInfo('v0')
    outputLog('差分無しテスト')
    v0NspPath = makerom.createNsp(outputDirectoryPath, 0, testpath.META_BASE_FILE_PATH)
    outputLog('v0.nsp size = ' + str(os.path.getsize(v0NspPath) / 1024 / 1024) + 'MB romfs = ' + str(romsize / 1024 / 1024) + 'MB')
    execute.installApplication(v0NspPath)
    execute.launchTest()

    # v1 差分無し
    printInfo('v1 差分無し')
    v1PatchPath = makerom.makePatch(outputDirectoryPath, v0NspPath, 1)
    outputLog('v1_patch.nsp size = ' + str(os.path.getsize(v1PatchPath) / 1024 / 1024) + 'MB romfs = ' + str(romsize / 1024 / 1024) + 'MB (増減無し)')
    execute.installPatch(v1PatchPath)
    execute.launchTest()

    # v2 差分無し
    printInfo('v2 差分無し')
    v2PatchPath = makerom.makePatch(outputDirectoryPath, v0NspPath, 2)
    v2OptimizePatchPath = makerom.optimizePatch(outputDirectoryPath, 2)
    v2DeltaPatchPath = makerom.deltaPatch(outputDirectoryPath, 2)
    outputLog('v2_opt_patch.nsp size = ' + str(os.path.getsize(v2OptimizePatchPath) / 1024 / 1024) + 'MB romfs = ' + str(romsize / 1024 / 1024) + 'MB (増減無し)')
    outputLog('v2_delta_patch.nsp size = ' + str(os.path.getsize(v2DeltaPatchPath) / 1024 / 1024) + 'MB (v1_patch.nsp -> v2_opt_patch.nsp 差分)')
    execute.installPatch(v2OptimizePatchPath)
    execute.launchTest()

    # v3 差分無し
    printInfo('v3 差分無し')
    v3PatchPath = makerom.makePatch(outputDirectoryPath, v0NspPath, 3)
    v3OptimizePatchPath = makerom.optimizePatch(outputDirectoryPath, 3)
    v3DeltaPatchPath = makerom.deltaPatch(outputDirectoryPath, 3)
    outputLog('v3_opt_patch.nsp size = ' + str(os.path.getsize(v3OptimizePatchPath) / 1024 / 1024) + 'MB romfs = ' + str(romsize / 1024 / 1024) + 'MB (増減無し)')
    outputLog('v3_delta_patch.nsp size = ' + str(os.path.getsize(v3DeltaPatchPath) / 1024 / 1024) + 'MB (v2_opt_patch.nsp -> v3_opt_patch.nsp 差分)')
    execute.installPatch(v3OptimizePatchPath)
    execute.launchTest()
    execute.uninstallApplication()

    os.remove(v1PatchPath)
    os.remove(v2PatchPath)
    os.remove(v2OptimizePatchPath)
    os.remove(v2DeltaPatchPath)
    os.remove(v3PatchPath)
    os.remove(v3OptimizePatchPath)
    os.remove(v3DeltaPatchPath)
    outputLog('')
    # ---

    # ---
    # ファイルのリサイズテスト
    execute.installApplication(v0NspPath)

    outputLog('ファイルのリサイズテスト')
    outputLog('v0.nsp size = ' + str(os.path.getsize(v0NspPath) / 1024 / 1024) + 'MB romfs = ' + str(romsize / 1024 / 1024) + 'MB')

    # v1 一部のファイルをリサイズ
    printInfo('v1 一部のファイルをリサイズ')
    resize = romfs.resizeRomFs(20)
    romsize += resize
    v1PatchPath = makerom.makePatch(outputDirectoryPath, v0NspPath, 1)
    outputLog('v1_patch.nsp size = ' + str(os.path.getsize(v1PatchPath) / 1024 / 1024) + 'MB romfs = ' + str(romsize / 1024 / 1024) + 'MB (' + str(resize / 1024 / 1024) + 'MB 増加)')
    execute.installPatch(v1PatchPath)
    execute.launchTest()

    # v2 一部のファイルをリサイズ（少なめ）
    printInfo('v2 一部のファイルをリサイズ（少なめ）')
    resize = romfs.resizeRomFs(10)
    romsize += resize
    v2PatchPath = makerom.makePatch(outputDirectoryPath, v0NspPath, 2)
    v2OptimizePatchPath = makerom.optimizePatch(outputDirectoryPath, 2)
    v2DeltaPatchPath = makerom.deltaPatch(outputDirectoryPath, 2)
    outputLog('v2_opt_patch.nsp size = ' + str(os.path.getsize(v2OptimizePatchPath) / 1024 / 1024) + 'MB romfs = ' + str(romsize / 1024 / 1024) + 'MB (' + str(resize / 1024 / 1024) + 'MB 増加)')
    outputLog('v2_delta_patch.nsp size = ' + str(os.path.getsize(v2DeltaPatchPath) / 1024 / 1024) + 'MB (v1_patch.nsp -> v2_opt_patch.nsp 差分)')
    execute.installPatch(v2OptimizePatchPath)
    execute.launchTest()

    # v3 一部のファイルをリサイズ（さらに少なめ）
    printInfo('v3 一部のファイルをリサイズ（さらに少なめ）')
    resize = romfs.resizeRomFs(5)
    romsize += resize
    v3PatchPath = makerom.makePatch(outputDirectoryPath, v0NspPath, 3)
    v3OptimizePatchPath = makerom.optimizePatch(outputDirectoryPath, 3)
    v3DeltaPatchPath = makerom.deltaPatch(outputDirectoryPath, 3)
    outputLog('v3_opt_patch.nsp size = ' + str(os.path.getsize(v3OptimizePatchPath) / 1024 / 1024) + 'MB romfs = ' + str(romsize / 1024 / 1024) + 'MB (' + str(resize / 1024 / 1024) + 'MB 増加)')
    outputLog('v3_delta_patch.nsp size = ' + str(os.path.getsize(v3DeltaPatchPath) / 1024 / 1024) + 'MB (v2_opt_patch.nsp -> v3_opt_patch.nsp 差分)')
    execute.installPatch(v3OptimizePatchPath)
    execute.launchTest()
    execute.uninstallApplication()

    os.remove(v0NspPath)
    os.remove(v1PatchPath)
    os.remove(v2PatchPath)
    os.remove(v2OptimizePatchPath)
    os.remove(v2DeltaPatchPath)
    os.remove(v3PatchPath)
    os.remove(v3OptimizePatchPath)
    os.remove(v3DeltaPatchPath)
    outputLog('')
    # ---

    romfs.cleanRomFs()
    romsize = romfs.createRomFs()

    # ---
    # 断片化テスト
    # v0
    printInfo('v0')
    outputLog('断片化テスト')
    v0NspPath = makerom.createNsp(outputDirectoryPath, 0, testpath.META_BASE_FILE_PATH)
    outputLog('v0.nsp size = ' + str(os.path.getsize(v0NspPath) / 1024 / 1024) + 'MB romfs = ' + str(romsize / 1024 / 1024) + 'MB')
    execute.installApplication(v0NspPath)

    # v1 ファイルを消して断片化
    printInfo('v1 ファイルを消して断片化')
    resize = romfs.fragmentRomFs(3)
    romsize -= resize
    v1PatchPath = makerom.makePatch(outputDirectoryPath, v0NspPath, 1)
    outputLog('v1_patch.nsp size = ' + str(os.path.getsize(v1PatchPath) / 1024 / 1024) + 'MB romfs = ' + str(romsize / 1024 / 1024) + 'MB (' + str(resize / 1024 / 1024) + 'MB 削減)')
    execute.installPatch(v1PatchPath)
    execute.launchTest()

    # v2 新たにファイル追加
    printInfo('v2 新たにファイル追加')
    resize = romfs.addRomFs()
    romsize += resize
    v2PatchPath = makerom.makePatch(outputDirectoryPath, v0NspPath, 2)
    v2OptimizePatchPath = makerom.optimizePatch(outputDirectoryPath, 2)
    v2DeltaPatchPath = makerom.deltaPatch(outputDirectoryPath, 2)
    outputLog('v2_opt_patch.nsp size = ' + str(os.path.getsize(v2OptimizePatchPath) / 1024 / 1024) + 'MB romfs = ' + str(romsize / 1024 / 1024) + 'MB (' + str(resize / 1024 / 1024) + 'MB 増加)')
    outputLog('v2_delta_patch.nsp size = ' + str(os.path.getsize(v2DeltaPatchPath) / 1024 / 1024) + 'MB (v1_patch.nsp -> v2_opt_patch.nsp 差分)')
    execute.installPatch(v2OptimizePatchPath)
    execute.launchTest()

    # v3 ファイルを消して断片化
    printInfo('v3 ファイルを消して断片化')
    resize = romfs.fragmentRomFs(2)
    romsize -= resize
    v3PatchPath = makerom.makePatch(outputDirectoryPath, v0NspPath, 3)
    v3OptimizePatchPath = makerom.optimizePatch(outputDirectoryPath, 3)
    v3DeltaPatchPath = makerom.deltaPatch(outputDirectoryPath, 3)
    outputLog('v3_opt_patch.nsp size = ' + str(os.path.getsize(v3OptimizePatchPath) / 1024 / 1024) + 'MB romfs = ' + str(romsize / 1024 / 1024) + 'MB (' + str(resize / 1024 / 1024) + 'MB 削減)')
    outputLog('v3_delta_patch.nsp size = ' + str(os.path.getsize(v3DeltaPatchPath) / 1024 / 1024) + 'MB (v2_opt_patch.nsp -> v3_opt_patch.nsp 差分)')
    execute.installPatch(v3OptimizePatchPath)
    execute.launchTest()
    execute.uninstallApplication()

    os.remove(v0NspPath)
    os.remove(v1PatchPath)
    os.remove(v2PatchPath)
    os.remove(v2OptimizePatchPath)
    os.remove(v2DeltaPatchPath)
    os.remove(v3PatchPath)
    os.remove(v3OptimizePatchPath)
    os.remove(v3DeltaPatchPath)
    outputLog('')
    # ---

    romfs.cleanRomFs()
    romsize = romfs.createRomFs()

    # ---
    # ディレクトリ追加削除テスト
    # v0
    printInfo('v0')
    outputLog('ディレクトリ追加削除テスト')
    v0NspPath = makerom.createNsp(outputDirectoryPath, 0, testpath.META_BASE_FILE_PATH)
    outputLog('v0.nsp size = ' + str(os.path.getsize(v0NspPath) / 1024 / 1024) + 'MB romfs = ' + str(romsize / 1024 / 1024) + 'MB')
    execute.installApplication(v0NspPath)

    # v1 新たにファイル追加
    printInfo('v1 新たにファイル追加')
    addsize = romfs.addRomFs()
    romsize += addsize
    v1PatchPath = makerom.makePatch(outputDirectoryPath, v0NspPath, 1)
    outputLog('v1_patch.nsp size = ' + str(os.path.getsize(v1PatchPath) / 1024 / 1024) + 'MB romfs = ' + str(romsize / 1024 / 1024) + 'MB (' + str(addsize / 1024 / 1024) + 'MB 増加)')
    execute.installPatch(v1PatchPath)
    execute.launchTest()

    # v2 新たにディレクトリとファイル追加
    printInfo('v2 新たにディレクトリとファイル追加')
    addsize = romfs.addDirTest()
    romsize += addsize
    v2PatchPath = makerom.makePatch(outputDirectoryPath, v0NspPath, 2)
    v2OptimizePatchPath = makerom.optimizePatch(outputDirectoryPath, 2)
    v2DeltaPatchPath = makerom.deltaPatch(outputDirectoryPath, 2)
    outputLog('v2_opt_patch.nsp size = ' + str(os.path.getsize(v2OptimizePatchPath) / 1024 / 1024) + 'MB romfs = ' + str(romsize / 1024 / 1024) + 'MB (' + str(addsize / 1024 / 1024) + 'MB 増加)')
    outputLog('v2_delta_patch.nsp size = ' + str(os.path.getsize(v2DeltaPatchPath) / 1024 / 1024) + 'MB (v1_patch.nsp -> v2_opt_patch.nsp 差分)')
    execute.installPatch(v2OptimizePatchPath)
    execute.launchTest()

    # v3 ファイルの削除と空ディレクトリの削除
    printInfo('v3 ファイルの削除と空ディレクトリの削除')
    delsize = romfs.deleteDirTest()
    romsize -= delsize
    v3PatchPath = makerom.makePatch(outputDirectoryPath, v0NspPath, 3)
    v3OptimizePatchPath = makerom.optimizePatch(outputDirectoryPath, 3)
    v3DeltaPatchPath = makerom.deltaPatch(outputDirectoryPath, 3)
    outputLog('v3_opt_patch.nsp size = ' + str(os.path.getsize(v3OptimizePatchPath) / 1024 / 1024) + 'MB romfs = ' + str(romsize / 1024 / 1024) + 'MB (' + str(delsize / 1024 / 1024) + 'MB 削減)')
    outputLog('v3_delta_patch.nsp size = ' + str(os.path.getsize(v3DeltaPatchPath) / 1024 / 1024) + 'MB (v2_opt_patch.nsp -> v3_opt_patch.nsp 差分)')
    execute.installPatch(v3OptimizePatchPath)
    execute.launchTest()
    execute.uninstallApplication()

    os.remove(v0NspPath)
    os.remove(v1PatchPath)
    os.remove(v2PatchPath)
    os.remove(v2OptimizePatchPath)
    os.remove(v2DeltaPatchPath)
    os.remove(v3PatchPath)
    os.remove(v3OptimizePatchPath)
    os.remove(v3DeltaPatchPath)
    outputLog('')
    # ---

    romfs.cleanRomFs()
    romsize = romfs.createRomFs()
    makerom.createResource()

    # ---
    # 4GBファイル追加テスト
    printInfo('v0')
    outputLog('4GBファイル追加テスト')
    v0NspPath = makerom.createNsp(outputDirectoryPath, 0, testpath.META_BASE_FILE_PATH)
    outputLog('v0.nsp size = ' + str(os.path.getsize(v0NspPath) / 1024 / 1024) + 'MB romfs = ' + str(romsize / 1024 / 1024) + 'MB')
    execute.installApplication(v0NspPath)

    # v1
    printInfo('v1')
    v1PatchPath = makerom.makePatch(outputDirectoryPath, v0NspPath, 1)
    outputLog('v1_patch.nsp size = ' + str(os.path.getsize(v1PatchPath) / 1024 / 1024) + 'MB romfs = ' + str(romsize / 1024 / 1024) + 'MB (増減無し)')
    execute.installPatch(v1PatchPath)
    execute.launchTest()

    # v2 4GBファイル追加
    printInfo('v2 4GBファイル追加')
    addsize = romfs.create4GFile()
    romsize += addsize
    v2PatchPath = makerom.makePatch(outputDirectoryPath, v0NspPath, 2)
    v2OptimizePatchPath = makerom.optimizePatch(outputDirectoryPath, 2)
    v2DeltaPatchPath = makerom.deltaPatch(outputDirectoryPath, 2)
    outputLog('v2_opt_patch.nsp size = ' + str(os.path.getsize(v2OptimizePatchPath) / 1024 / 1024) + 'MB romfs = ' + str(romsize / 1024 / 1024) + 'MB (' + str(addsize / 1024 / 1024) + 'MB 増加)')
    outputLog('v2_delta_patch.nsp size = ' + str(os.path.getsize(v2DeltaPatchPath) / 1024 / 1024) + 'MB (v1_patch.nsp -> v2_opt_patch.nsp 差分)')
    execute.installPatch(v2OptimizePatchPath)
    execute.launchTest()

    # v3 4GBファイル削除
    printInfo('v3 4GBファイル削除')
    delsize = romfs.delete4GFile()
    romsize -= delsize
    v3PatchPath = makerom.makePatch(outputDirectoryPath, v0NspPath, 3)
    v3OptimizePatchPath = makerom.optimizePatch(outputDirectoryPath, 3)
    v3DeltaPatchPath = makerom.deltaPatch(outputDirectoryPath, 3)
    outputLog('v3_opt_patch.nsp size = ' + str(os.path.getsize(v3OptimizePatchPath) / 1024 / 1024) + 'MB romfs = ' + str(romsize / 1024 / 1024) + 'MB (' + str(delsize / 1024 / 1024) + 'MB 削減)')
    outputLog('v3_delta_patch.nsp size = ' + str(os.path.getsize(v3DeltaPatchPath) / 1024 / 1024) + 'MB (v2_opt_patch.nsp -> v3_opt_patch.nsp 差分)')
    execute.installPatch(v3OptimizePatchPath)
    execute.launchTest()
    execute.uninstallApplication()

    os.remove(v0NspPath)
    os.remove(v1PatchPath)
    os.remove(v2PatchPath)
    os.remove(v2OptimizePatchPath)
    os.remove(v2DeltaPatchPath)
    os.remove(v3PatchPath)
    os.remove(v3OptimizePatchPath)
    os.remove(v3DeltaPatchPath)
    outputLog('')
    # ---

    romfs.cleanRomFs()
    romfs.createRomFs()

if __name__ == '__main__':
    main()

