﻿# coding: UTF-8

import os
import subprocess
import xml.dom.minidom
import sys
import time
import testpath

def printInfo(s):
    print s
    sys.stdout.flush()

def createResource():
    subprocess.call([testpath.NACT_PATH, 'BUILD=Develop', 'specs=NX', 'platforms=NXFP2-a64', '-d', testpath.TEST_PATH])

def createNsp(outputDirectoryPath, version, metaPath):
    programPath = os.path.normpath(outputDirectoryPath + '/code')
    dataPath = testpath.ROM_RESOURCE_DIRECTORY_PATH
    outputPath = os.path.normpath(outputDirectoryPath + '/v' + str(version) + '.nsp')

    timeBegin = time.time()
    subprocess.check_output([testpath.AUTHORING_TOOL_PATH, 'creatensp', '-o', outputPath, '--type', 'Application', '--meta', metaPath, '--desc', testpath.DESC_FILE_PATH, '--program', programPath, dataPath])
    timeElapsed = time.time() - timeBegin
    printInfo('creatensp elapsed: ' + str(timeElapsed) + ' sec')

    return outputPath

def makeVersionedMeta(outputDirectoryPath, type, version):
    dom = xml.dom.minidom.parse(testpath.META_BASE_FILE_PATH)
    metaElement = dom.getElementsByTagName('NintendoSdkMeta')[0]
    l_applicationElements = metaElement.getElementsByTagName(type)
    if l_applicationElements:
        applicationElement = l_applicationElements[0]

        # IconPath を更新
        iconPathNode = applicationElement.getElementsByTagName('Icon')[0].getElementsByTagName('IconPath')[0].childNodes[0]
        iconPathNode.nodeValue = os.path.normpath(os.path.join(testpath.SIGLO_ROOT, iconPathNode.nodeValue.replace('../', '')))
    else:
        applicationElement = metaElement.appendChild(dom.createElement(type))
    l_versionElements = applicationElement.getElementsByTagName('Version')
    if l_versionElements:
        applicationElement.removeChild(l_versionElements[0])
    versionElement = applicationElement.appendChild(dom.createElement('Version'))
    versionElement.appendChild(dom.createTextNode(str(version)))

    outputPath = os.path.normpath(outputDirectoryPath + '/v' + str(version) + '.meta')
    with open(outputPath, 'w') as outputFile:
        dom.writexml(outputFile)
    return outputPath

def makePatch(outputDirectoryPath, originalNspPath, version):
    metaPath = makeVersionedMeta(outputDirectoryPath, 'Application', version)
    currentNspPath = createNsp(outputDirectoryPath, version, metaPath)

    outputPath = os.path.normpath(outputDirectoryPath + '/v' + str(version) + '_patch.nsp')
    timeBegin = time.time()
    subprocess.check_output([testpath.AUTHORING_TOOL_PATH, 'makepatch', '-o', outputPath, '--desc', testpath.DESC_FILE_PATH, '--original', originalNspPath, '--current', currentNspPath])
    timeElapsed = time.time() - timeBegin
    printInfo('makepatch elapsed: ' + str(timeElapsed) + ' sec')

    os.remove(metaPath)
    os.remove(currentNspPath)

    return outputPath

def optimizePatch(outputDirectoryPath, version):
    currentPatchPath = os.path.normpath(outputDirectoryPath + '/v' + str(version) + '_patch.nsp')
    if version > 1:
        if version == 2:
            previousPatchPath = os.path.normpath(outputDirectoryPath + '/v' + str(version - 1) + '_patch.nsp')
        else:
            previousPatchPath = os.path.normpath(outputDirectoryPath + '/v' + str(version - 1) + '_opt_patch.nsp')
        outputPath = os.path.normpath(outputDirectoryPath + '/v' + str(version) + '_opt_patch.nsp')

        timeBegin = time.time()
        subprocess.check_output([testpath.AUTHORING_TOOL_PATH, 'optimizepatch', '-o', outputPath, '--desc', testpath.DESC_FILE_PATH, '--previous', previousPatchPath, '--current', currentPatchPath])
        timeElapsed = time.time() - timeBegin
        printInfo('optimizepatch elapsed: ' + str(timeElapsed) + ' sec')

        return outputPath
    else:
        return currentPath

def deltaPatch(outputDirectoryPath, version):
    metaPath = makeVersionedMeta(outputDirectoryPath, 'Delta', version)
    currentPatchPath = os.path.normpath(outputDirectoryPath + '/v' + str(version) + '_opt_patch.nsp')
    if version > 1:
        if version == 2:
            previousPatchPath = os.path.normpath(outputDirectoryPath + '/v' + str(version - 1) + '_patch.nsp')
        else:
            previousPatchPath = os.path.normpath(outputDirectoryPath + '/v' + str(version - 1) + '_opt_patch.nsp')
        outputPath = os.path.normpath(outputDirectoryPath + '/v' + str(version) + '_delta_patch.nsp')

        timeBegin = time.time()
        subprocess.check_output([testpath.AUTHORING_TOOL_PATH, 'makedelta', '-o', outputPath, '--source', previousPatchPath, '--destination', currentPatchPath, '--meta', metaPath])
        timeElapsed = time.time() - timeBegin
        printInfo('makedelta elapsed: ' + str(timeElapsed) + ' sec')

        os.remove(metaPath)
        os.remove(os.path.normpath(outputDirectoryPath + '/v' + str(version) + '_delta_patch.nsp.adf'))

        return outputPath
    else:
        return currentPath
