﻿# coding: UTF-8

import os
import random
import sys
import shutil

sys.path.append(os.path.dirname(os.path.abspath(__file__)) + '/../../PatchCommon')
import execute
import makerom
import romfs
import patchtest

PERFORMANCE_TEST_NAME = 'PerformanceTestReadPatch.ReadFile'

def changeFileRandom(filePath):
    with open(filePath, 'r+b') as outputFile:
        fileSize = os.path.getsize(filePath)
        outputFile.seek(random.randint(0, fileSize - 1))
        outputFile.write(bytearray([random.randint(0, 255)]))

def main():
    platform = 'NX-NXFP2-a64'
    buildType = 'Release'
    fileSize = 4 * 1024 * 1024
    endVersion = 4
    applicationMedia = "builtin"
    patchMedia = "builtin"

    argv = sys.argv
    if len(argv) >= 2:
        platform = argv[1]
    if len(argv) >= 3:
        buildType = argv[2]
    if platform.startswith('NXFP2-a'):
        platform = 'NX-' + platform # NXFP2-aXX → NX-NXFP2-aXX
    if len(argv) >= 4:
        endVersion = int(argv[3])
    if endVersion < 0:
        sys.exit(1)
    if len(argv) >= 5:
        execute.setTargetAddress(argv[4])
    if len(argv) >= 6:
        applicationMedia = argv[5]
    if len(argv) >= 7:
        patchMedia = argv[6]
    if not execute.checkMediaCombination(applicationMedia, patchMedia):
        sys.exit(1)

    random.seed(0)

    patchtest.updatePath(platform, buildType, 'PerformanceReadPatch')

    execute.setupSdCard(applicationMedia, patchMedia)
    execute.uninstallApplication()

    romfs.initializeResourceDirectory()
    romResourceFilePath = patchtest.g_ResourceDirectoryPath + '/1'
    romfs.createFile(romResourceFilePath, fileSize)

    # v0
    patchtest.printf('v0')
    v0NspPath = makerom.createOriginalNsp()
    execute.setupApplication(v0NspPath, applicationMedia)
    execute.launchTest(PERFORMANCE_TEST_NAME, [patchtest.g_ResourceDirectoryPath])

    if endVersion > 0:
        # v1
        patchtest.printf('v1')
        changeFileRandom(romResourceFilePath)
        v1PatchPath = makerom.makePatch(1)
        execute.setupPatch(v0NspPath, v1PatchPath, patchMedia)
        execute.launchTest(PERFORMANCE_TEST_NAME, [patchtest.g_ResourceDirectoryPath])

        # v2~
        previousPatchPath = v1PatchPath
        for version in range(2, endVersion + 1):
            patchtest.printf('v%d', version)

            changeFileRandom(romResourceFilePath)
            makerom.makePatch(version)
            optimizedPatchPath = makerom.optimizePatch(version)
            execute.setupPatch(v0NspPath, optimizedPatchPath, patchMedia)
            execute.launchTest(PERFORMANCE_TEST_NAME, [patchtest.g_ResourceDirectoryPath])

    execute.uninstallApplication()

if __name__ == '__main__':
    main()

