﻿# coding: UTF-8

import os
import random
import sys
import shutil

sys.path.append(os.path.dirname(os.path.abspath(__file__)) + '/../../PatchCommon')
import execute
import makerom
import romfs
import patchtest

PERFORMANCE_TEST_NAME = 'PerformanceTestReadGapPatch.ReadFile'
PERFORMANCE_TEST_NAME_PATCH = 'PerformanceTestReadGapPatch.ReadPatchedFiles'

FILE_SIZE = 4 * 1024 * 1024
BUFFER_SIZE = 4 * 1024 * 1024;

FILE_GAPS = [0, 16, 32, 48, 64, 80, 96, 112, 128, 256, 512]
FILE_NAMES = [str(i) + '_' + str(gap) for i, gap in enumerate(FILE_GAPS)]

def createFiles(directoryPath):
    if os.path.exists(directoryPath):
        shutil.rmtree(directoryPath)
    os.mkdir(directoryPath)
    for name in FILE_NAMES:
        filePath = directoryPath + '/' + name
        romfs.createFile(filePath, FILE_SIZE)

def changeFiles(directoryPath, version):
    for i in xrange(len(FILE_GAPS) - 1):
        gapSize = FILE_GAPS[i + 1] - FILE_GAPS[i]
        filePath = directoryPath + '/' + str(i) + 'padding' + str(version)
        romfs.createFile(filePath, gapSize)

def main():

    platform = 'NX-NXFP2-a64'
    buildType = 'Release'
    endVersion = 4
    applicationMedia = "builtin"
    patchMedia = "builtin"

    argv = sys.argv
    if len(argv) >= 2:
        platform = argv[1]
    if len(argv) >= 3:
        buildType = argv[2]
    if len(argv) >= 4:
        endVersion = int(argv[3])
    if len(argv) >= 5:
        execute.setTargetAddress(argv[4])
    if len(argv) >= 6:
        applicationMedia = argv[5]
    if len(argv) >= 7:
        patchMedia = argv[6]

    if platform.startswith('NXFP2-a'):
        platform = 'NX-' + platform # NXFP2-aXX → NX-NXFP2-aXX
    if endVersion < 0:
        sys.exit(1)
    if not execute.checkMediaCombination(applicationMedia, patchMedia):
        sys.exit(1)

    random.seed(0)

    patchtest.updatePath(platform, buildType, 'PerformanceReadGapPatch')

    execute.setupSdCard(applicationMedia, patchMedia)
    execute.uninstallApplication()

    createFiles(patchtest.g_ResourceDirectoryPath)

    # v0
    patchtest.printf('v0')
    v0NspPath = makerom.createOriginalNsp()
    execute.setupApplication(v0NspPath, applicationMedia)
    execute.launchTest(PERFORMANCE_TEST_NAME, ['--gtest_filter=' + PERFORMANCE_TEST_NAME])

    if endVersion > 0:
        # v1
        patchtest.printf('v1')
        changeFiles(patchtest.g_ResourceDirectoryPath, 1)
        v1PatchPath = makerom.makePatch(1)
        execute.setupPatch(v0NspPath, v1PatchPath, patchMedia)
        execute.launchTest(PERFORMANCE_TEST_NAME_PATCH, ['--gtest_filter=' + PERFORMANCE_TEST_NAME_PATCH])

        # v2~
        previousPatchPath = v1PatchPath
        for version in range(2, endVersion + 1):
            patchtest.printf('v%d', version)

            changeFiles(patchtest.g_ResourceDirectoryPath, version)
            makerom.makePatch(version)
            optimizedPatchPath = makerom.optimizePatch(version)
            execute.setupPatch(v0NspPath, optimizedPatchPath, patchMedia)
            execute.launchTest(PERFORMANCE_TEST_NAME_PATCH, ['--gtest_filter=' + PERFORMANCE_TEST_NAME_PATCH])

    execute.uninstallApplication()

if __name__ == '__main__':
    main()

