﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os.h>
#include <nn/fs.h>
#include <nnt/fsUtil/testFs_util.h>

// マクロ定義を間借り
#define MyAbort(result) NN_ABORT_UNLESS_RESULT_SUCCESS(result);

#define NN_FS_TEST_RESULT_DO(result) \
    { \
        const auto& _nn_fs_result_temporary = result; \
        if(_nn_fs_result_temporary.IsFailure()) \
        { \
            NN_LOG("**** ABORT in AgingTest ***\n"); \
            NN_LOG("%s() - %s:%d\n", __FUNCTION__, __FILE__, __LINE__); \
            NN_LOG("Failure Result : (Module:%d, Description:%d)\n", _nn_fs_result_temporary.GetModule(), _nn_fs_result_temporary.GetDescription()); \
            NN_LOG("Thread Name : %s\n", nn::os::GetThreadNamePointer(nn::os::GetCurrentThread())); \
            NN_RESULT_DO(_nn_fs_result_temporary);\
        } \
    }

#define MY_ABORT_UNLESS_RESULT_SUCCESS(func, ...) {auto resultTmp_ = func; if(resultTmp_.IsFailure()){NN_SDK_LOG(__VA_ARGS__); MyAbort(resultTmp_);} }

// ファイルシステムの初期化（作成など）、マウントを提供する
class IFileSystemProvider
{
public:
    virtual void Initialize() {}
    virtual void Mount() = 0;
    virtual void Unmount() = 0;
    virtual void Clean() {}
    virtual nnt::fs::util::String GetMountName() = 0;
    virtual nn::fs::fsa::IFileSystem* GetFileSystem() = 0;
};
