﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs/fs_Bis.h>
#include <nn/fs/fs_SaveDataForDebug.h>
#include <nn/fs/fs_SdCardForDebug.h>
#include <nn/fs/fs_ImageDirectory.h>

#include "testFs_FsLib_Mount.h"

TEST(MountVariousFsTest, RenameToOtherFileSystem)
{
    NNT_ASSERT_RESULT_SUCCESS(nn::fs::MountSaveDataForDebug("SaveData"));
    NN_UTIL_SCOPE_EXIT
    {
        nn::fs::Unmount("SaveData");
    };

    NNT_ASSERT_RESULT_SUCCESS(nn::fs::MountHost("Host", g_TestDirPath.GetPath().c_str()));
    NN_UTIL_SCOPE_EXIT
    {
        nn::fs::Unmount("Host");
    };

    NNT_ASSERT_RESULT_SUCCESS(nn::fs::MountBis("Bis", nn::fs::BisPartitionId::User));
    NN_UTIL_SCOPE_EXIT
    {
        nn::fs::Unmount("Bis");
    };

    NNT_ASSERT_RESULT_SUCCESS(nn::fs::MountImageDirectory("Image_Nand", nn::fs::ImageDirectoryId::Nand));
    NN_UTIL_SCOPE_EXIT
    {
        nn::fs::Unmount("Image_Nand");
    };

    NNT_ASSERT_RESULT_SUCCESS(nn::fs::MountImageDirectory("Image_SdCard", nn::fs::ImageDirectoryId::SdCard));
    NN_UTIL_SCOPE_EXIT
    {
        nn::fs::Unmount("Image_SdCard");
    };

    NNT_ASSERT_RESULT_SUCCESS(nn::fs::MountSdCardForDebug("SdCard"));
    NN_UTIL_SCOPE_EXIT
    {
        nn::fs::Unmount("SdCard");
    };


    const char* MountName[] = {
        "SaveData",
        "Host",
        "Bis",
        "Image_Nand",
        "Image_SdCard",
        "SdCard"
    };

    int fileSystemCount = sizeof(MountName) / sizeof(const char*);

    for( int i = 0; i < fileSystemCount; ++i )
    {
        for( int j = 0; j < fileSystemCount; ++j )
        {
            if( i != j )
            {
                nnt::fs::util::String srcFilePath = nnt::fs::util::String(MountName[i]) + ":/srcFile";
                nnt::fs::util::String dstFilePath = nnt::fs::util::String(MountName[j]) + ":/dstFile";

                NNT_ASSERT_RESULT_FAILURE(
                    nn::fs::ResultInvalidArgument,
                    nn::fs::RenameFile(srcFilePath.c_str(), dstFilePath.c_str())
                );
            }
        }
    }
}
