﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <random>
#include <nn/fs.h>

#include <nn/util/util_ScopeExit.h>

#include <nnt/nntest.h>
#include <nnt/fsUtil/testFs_util.h>

#include "testFs_FsLib_AccessLog.h"

// ランダムなアクセスを行われた場合にも、アクセスログが出力されることを確認するテスト
// ランダムなアクセスログが出力されるため、アクセスログ出力確認テストでは実行しません
TEST(RandomAccessLog, MakeRandomFetchAccessLog)
{
    static std::mt19937 mt(nnt::fs::util::GetRandomSeed());

    size_t fileCacheBufferSize = 2 * 1024 * 1024;
    auto fileDataCacheBuffer = nnt::fs::util::AllocateBuffer(fileCacheBufferSize);
    nn::fs::EnableGlobalFileDataCache(fileDataCacheBuffer.get(), fileCacheBufferSize);
    NN_UTIL_SCOPE_EXIT
    {
        nn::fs::DisableGlobalFileDataCache();
    };
    {
        size_t cacheBufferSize = 0;
        NNT_ASSERT_RESULT_SUCCESS(nn::fs::QueryMountRomCacheSize(&cacheBufferSize));
        auto cacheBuffer = nnt::fs::util::AllocateBuffer(cacheBufferSize);
        ASSERT_NE(nullptr, cacheBuffer);
        NNT_ASSERT_RESULT_SUCCESS(nn::fs::MountRom(nnt::fs::MountName, cacheBuffer.get(), cacheBufferSize));
        NN_UTIL_SCOPE_EXIT
        {
            nn::fs::Unmount(nnt::fs::MountName);
        };
        {
            nn::fs::FileHandle handle;
            const char* filePath = "test:/4MB";
            NNT_ASSERT_RESULT_SUCCESS(nn::fs::OpenFile(&handle, filePath, nn::fs::OpenMode_Read));
            NN_UTIL_SCOPE_EXIT
            {
                nn::fs::CloseFile(handle);
            };
            size_t readBufferSize = 4 * 1024 * 1024;
            auto readBuffer = nnt::fs::util::AllocateBuffer(readBufferSize);
            for( int i = 0; i < 1024; ++i)
            {
                int64_t offset = std::uniform_int_distribution<>(0, static_cast<int>(readBufferSize))(mt);
                size_t size = std::uniform_int_distribution<>(1, static_cast<int>(readBufferSize))(mt);
                (void)nn::fs::ReadFile(handle, offset, readBuffer.get(), size);
            }
        }
    }
}
