﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/nn_Log.h>
#include <nn/pdm/pdm_Api.h>
#include <nn/pdm/pdm_QueryApiForSystem.h>

#include <nnt/nntest.h>

TEST(PdmQueryApplicationPlayStatistics, Success)
/*
AccessLogTest: NX
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "QueryApplicationPlayStatistics" }
AccessLogTest: NX-system
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "QueryApplicationPlayStatistics" }
AccessLogTest: Generic
AccessLogTest: Generic-system
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "nn::fs::CommitSaveData", name: "pdm" }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0xFEDCBA0987654321, priority: Normal, function: "nn::fs::OpenFile", path: "pdm:/PlayEvent.dat", open_mode: 0x1 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0xFEDCBA0987654321, priority: Normal, function: "ReadFile", offset: 8, size: 1 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0xFEDCBA0987654321, priority: Normal, function: "nn::fs::CloseFile" }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "nn::pdm::QueryApplicationPlayStatisticsForSystem" }
*/
{
    nn::pdm::ApplicationPlayStatistics statistics[5];
    nn::ApplicationId applicationId[] = {{0x0005000C10000000ULL},
                                         {0x0005000C10000000ULL},
                                         {0x0005000C10000000ULL},
                                         {0x0005000C10000000ULL},
                                         {0x0005000C10000000ULL}};
    int count = nn::pdm::QueryApplicationPlayStatistics(statistics, applicationId, 5);
    NN_UNUSED(count);

#if defined(NN_BUILD_CONFIG_OS_WIN)
    nn::ncm::ApplicationId applicationIdForSystem[] = {{0x0005000C10000000ULL},
                                                       {0x0005000C10000000ULL},
                                                       {0x0005000C10000000ULL},
                                                       {0x0005000C10000000ULL},
                                                       {0x0005000C10000000ULL}};
    int resultSystem = nn::pdm::QueryApplicationPlayStatisticsForSystem(statistics, applicationIdForSystem, 5);
    NN_UNUSED(resultSystem);
    // 優先度変更のログが出るのを待つ
    nn::os::SleepThread(nn::TimeSpan::FromSeconds(1));
#endif
}

TEST(PdmQueryApplicationPlayStatistics, DISABLED_Failure)
{}
