﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs.h>
#include <nn/ncm/ncm_ContentMetaId.h>

#include <nn/fs/fs_CacheStoragePrivate.h>
#include <nn/fs/fs_CacheStorageWithIndex.h>
#include <nn/fs/fs_SaveDataManagementPrivate.h>

#include "testFs_FsLib_AccessLog.h"

#if defined(NN_BUILD_CONFIG_HARDWARE_NX)
namespace
{
    bool g_IsTemporaryStorageCreated = false;
}

TEST(MountCacheStorage, Success)
/*
AccessLogTest: NX
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "CreateCacheStorage", index: 0, save_data_size: 65536, save_data_journal_size: 65536 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "MountCacheStorage", name: "test" }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "Unmount", name: "test" }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "MountCacheStorage", name: "test", index: 0 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "Unmount", name: "test" }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "DeleteCacheStorage", index: 0 }
AccessLogTest: NX-system
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "CreateCacheStorage", index: 0, save_data_size: 65536, save_data_journal_size: 65536 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "MountCacheStorage", name: "test" }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "Unmount", name: "test" }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "MountCacheStorage", name: "test", applicationid: 0x100000000003006 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "Unmount", name: "test" }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "MountCacheStorage", name: "test", index: 0 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "Unmount", name: "test" }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "MountCacheStorage", name: "test", applicationid: 0x100000000003006, index: 0 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "Unmount", name: "test" }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "DeleteCacheStorage", index: 0 }
*/
{
    int index = 0;
    NNT_ASSERT_RESULT_SUCCESS(nn::fs::CreateCacheStorage(index, 0x10000, 0x10000));
    NNT_ASSERT_RESULT_SUCCESS(nn::fs::MountCacheStorage(nnt::fs::MountName));
    nn::fs::Unmount(nnt::fs::MountName);

    NNT_ASSERT_RESULT_SUCCESS(nn::fs::MountCacheStorage(nnt::fs::MountName, nnt::fs::ApplicationId));
    nn::fs::Unmount(nnt::fs::MountName);

    NNT_ASSERT_RESULT_SUCCESS(nn::fs::MountCacheStorage(nnt::fs::MountName, index));
    nn::fs::Unmount(nnt::fs::MountName);

    NNT_ASSERT_RESULT_SUCCESS(nn::fs::MountCacheStorage(nnt::fs::MountName, nnt::fs::ApplicationId, index));
    nn::fs::Unmount(nnt::fs::MountName);

    NNT_ASSERT_RESULT_SUCCESS(nn::fs::DeleteCacheStorage(index));
}

TEST(MountCacheStorage, Failure)
/*
AccessLogTest: NX
FS_ACCESS: { start: 0, end: 0, result: 0x0007D402, handle: 0x0000000000000000, priority: Normal, function: "MountCacheStorage", name: "test" }
FS_ACCESS: { start: 0, end: 0, result: 0x0007D402, handle: 0x0000000000000000, priority: Normal, function: "MountCacheStorage", name: "test", index: 0 }
AccessLogTest: NX-system
FS_ACCESS: { start: 0, end: 0, result: 0x0007D402, handle: 0x0000000000000000, priority: Normal, function: "MountCacheStorage", name: "test" }
FS_ACCESS: { start: 0, end: 0, result: 0x0007D402, handle: 0x0000000000000000, priority: Normal, function: "MountCacheStorage", name: "test", applicationid: 0x100000000003006 }
FS_ACCESS: { start: 0, end: 0, result: 0x0007D402, handle: 0x0000000000000000, priority: Normal, function: "MountCacheStorage", name: "test", index: 0 }
FS_ACCESS: { start: 0, end: 0, result: 0x0007D402, handle: 0x0000000000000000, priority: Normal, function: "MountCacheStorage", name: "test", applicationid: 0x100000000003006, index: 0 }
*/
{
    ASSERT_TRUE(nn::fs::MountCacheStorage(nnt::fs::MountName).IsFailure());
    ASSERT_TRUE(nn::fs::MountCacheStorage(nnt::fs::MountName, nnt::fs::ApplicationId).IsFailure());
    ASSERT_TRUE(nn::fs::MountCacheStorage(nnt::fs::MountName, 0).IsFailure());
    ASSERT_TRUE(nn::fs::MountCacheStorage(nnt::fs::MountName, nnt::fs::ApplicationId, 0).IsFailure());
}

TEST(MountCacheStorageList, Success)
/*
AccessLogTest: NX
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "CreateCacheStorage", index: 1, save_data_size: 65536, save_data_journal_size: 65536 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "CreateCacheStorage", index: 2, save_data_size: 65536, save_data_journal_size: 65536 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "GetCacheStorageSize", index: 2 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "OpenCacheStorageList", cachestoragelist_handle: 0xFEDCBA09 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "ReadCacheStorageList", cachestoragelist_handle: 0xFEDCBA09, infobuffercount: 0x3 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "CloseCacheStorageList", cachestoragelist_handle: 0xFEDCBA09 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "DeleteCacheStorage", index: 1 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "DeleteCacheStorage", index: 2 }
AccessLogTest: NX-system
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "CreateCacheStorage", index: 1, save_data_size: 65536, save_data_journal_size: 65536 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "CreateCacheStorage", index: 2, save_data_size: 65536, save_data_journal_size: 65536 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "GetCacheStorageSize", index: 2 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "OpenCacheStorageList", cachestoragelist_handle: 0xFEDCBA09 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "ReadCacheStorageList", cachestoragelist_handle: 0xFEDCBA09, infobuffercount: 0x3 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "CloseCacheStorageList", cachestoragelist_handle: 0xFEDCBA09 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "DeleteCacheStorage", index: 1 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "DeleteCacheStorage", index: 2 }
*/
{
    int index1 = 1;
    int index2 = 2;
    NNT_ASSERT_RESULT_SUCCESS(nn::fs::CreateCacheStorage(index1, 0x10000, 0x10000));
    NNT_ASSERT_RESULT_SUCCESS(nn::fs::CreateCacheStorage(index2, 0x10000, 0x10000));

    int64_t cacheStorageSize = 0;
    int64_t cacheStorageJournalSize = 0;
    NNT_ASSERT_RESULT_SUCCESS(nn::fs::GetCacheStorageSize(&cacheStorageSize, &cacheStorageJournalSize, index2));

    nn::fs::CacheStorageListHandle handle;
    NNT_ASSERT_RESULT_SUCCESS(nn::fs::OpenCacheStorageList(&handle));
    int value = 0;
    nn::fs::CacheStorageInfo infoBuffer[3];
    NNT_ASSERT_RESULT_SUCCESS(nn::fs::ReadCacheStorageList(&value, infoBuffer, handle, 3));
    nn::fs::CloseCacheStorageList(handle);

    NNT_ASSERT_RESULT_SUCCESS(nn::fs::DeleteCacheStorage(index1));
    NNT_ASSERT_RESULT_SUCCESS(nn::fs::DeleteCacheStorage(index2));
}

TEST(MountCacheStorageList, Failure)
/*
AccessLogTest: NX
FS_ACCESS: { start: 0, end: 0, result: 0x002EE202, handle: 0x0000000000000000, priority: Normal, function: "CreateCacheStorage", index: 65535, save_data_size: 65536, save_data_journal_size: 65536 }
AccessLogTest: NX-system
FS_ACCESS: { start: 0, end: 0, result: 0x002EE202, handle: 0x0000000000000000, priority: Normal, function: "CreateCacheStorage", index: 65535, save_data_size: 65536, save_data_journal_size: 65536 }
*/
{
    int index = -1;
    ASSERT_TRUE(nn::fs::CreateCacheStorage(index, 0x10000, 0x10000).IsFailure());

    int64_t cacheStorageSize = 0;
    int64_t cacheStorageJournalSize = 0;
    ASSERT_TRUE(nn::fs::GetCacheStorageSize(&cacheStorageSize, &cacheStorageJournalSize, index).IsFailure());

    ASSERT_TRUE(nn::fs::DeleteCacheStorage(index).IsFailure());
}

TEST(CreateDeleteCacheStorage, Success)
/*
AccessLogTest: NX
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "CreateCacheStorage", index: 1, save_data_size: 65536, save_data_journal_size: 65536 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "DeleteCacheStorage", index: 1 }
AccessLogTest: NX-system
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "CreateCacheStorage", index: 1, save_data_size: 65536, save_data_journal_size: 65536 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "DeleteCacheStorage", index: 1 }
*/
{
    int index = 1;
    NNT_ASSERT_RESULT_SUCCESS(nn::fs::CreateCacheStorage(index, 0x10000, 0x10000));
    NNT_ASSERT_RESULT_SUCCESS(nn::fs::DeleteCacheStorage(index));
}

TEST(CreateDeleteCacheStorage, Failure)
/*
AccessLogTest: NX
AccessLogTest: NX-system
FS_ACCESS: { start: 0, end: 0, result: 0x00345802, handle: 0x0000000000000000, priority: Normal, function: "CreateCacheStorage", applicationid: 0x100000000003006, savedataspaceid: User, save_data_owner_id: 0x0, save_data_size: 4096, save_data_journal_size: 4096, save_data_flags: 0x00000005 }
FS_ACCESS: { start: 0, end: 0, result: 0x00345802, handle: 0x0000000000000000, priority: Normal, function: "CreateCacheStorage", applicationid: 0x100000000003006, savedataspaceid: User, save_data_owner_id: 0x0, save_data_size: 4096, save_data_journal_size: 4096, save_data_flags: 0x00000006 }
FS_ACCESS: { start: 0, end: 0, result: 0x00345802, handle: 0x0000000000000000, priority: Normal, function: "CreateCacheStorage", applicationid: 0x100000000003006, savedataspaceid: User, save_data_owner_id: 0x0, save_data_size: 4096, save_data_journal_size: 4096, save_data_flags: 0x00000007 }
*/
{
    ASSERT_TRUE(nn::fs::CreateCacheStorage(nnt::fs::ApplicationId, 0, 0x1000, 0x1000, 0x5).IsFailure());
    ASSERT_TRUE(nn::fs::CreateCacheStorage(nnt::fs::ApplicationId, nn::fs::SaveDataSpaceId::User, 0, 0x1000, 0x1000, 0x6).IsFailure());
    ASSERT_TRUE(nn::fs::CreateCacheStorage(nnt::fs::ApplicationId, nn::fs::SaveDataSpaceId::User, 0, 0, 0x1000, 0x1000, 0x7).IsFailure());
}

TEST(MountTemporaryStorage, SuccessFailure)
/*
AccessLogTest: NX
FS_ACCESS: { start: 0, end: 0, result: 0x0007D402, handle: 0x0000000000000000, priority: Normal, function: "MountTemporaryStorage", name: "test" }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "MountTemporaryStorage", name: "test" }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "Unmount", name: "test" }
AccessLogTest: NX-system
FS_ACCESS: { start: 0, end: 0, result: 0x0007D402, handle: 0x0000000000000000, priority: Normal, function: "MountTemporaryStorage", name: "test" }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "CreateTemporaryStorage", applicationid: 0x100000000003006, save_data_owner_id: 0x1, save_data_size: 65536, save_data_flags: 0x00000000 }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "MountTemporaryStorage", name: "test" }
FS_ACCESS: { start: 0, end: 0, result: 0x00000000, handle: 0x0000000000000000, priority: Normal, function: "Unmount", name: "test" }
*/
{
    if( !g_IsTemporaryStorageCreated )
    {
        ASSERT_TRUE(nn::fs::MountTemporaryStorage(nnt::fs::MountName).IsFailure());
        NNT_ASSERT_RESULT_SUCCESS(nn::fs::CreateTemporaryStorage(nnt::fs::ApplicationId, 1, 0x10000, 0));
        g_IsTemporaryStorageCreated = true;
    }
    NNT_ASSERT_RESULT_SUCCESS(nn::fs::MountTemporaryStorage(nnt::fs::MountName));
    nn::fs::Unmount(nnt::fs::MountName);
}
#endif
