﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/fsUtil/testFs_util_allocator.h>
#include <nnt/fsUtil/testFs_util_fixture.h>
#include <nnt/fsUtil/testFs_util_function.h>

namespace nnt { namespace fs { namespace util {

// CheckMemoryLeakFixture
CheckMemoryLeakFixture::CheckMemoryLeakFixture() NN_NOEXCEPT
    :   m_MemoryAllocatedSize(0),
        m_Enabled(true)
{
}

void CheckMemoryLeakFixture::StartMemoryCheck() NN_NOEXCEPT
{
    m_MemoryAllocatedSize = nnt::fs::util::GetStartAllocateSize();
}

void CheckMemoryLeakFixture::StopMemoryLeakCheck() NN_NOEXCEPT
{
    if (m_Enabled == true)
    {
        EXPECT_FALSE(nnt::fs::util::CheckMemoryLeak(m_MemoryAllocatedSize));
    }
}

void CheckMemoryLeakFixture::DisableCheck() NN_NOEXCEPT
{
    m_Enabled = false;
}

// CheckGlobalNewDeleteFlagTestFixture
CheckGlobalNewDeleteFlagTestFixture::CheckGlobalNewDeleteFlagTestFixture() NN_NOEXCEPT
    : m_Enabled(true)
{
}

void CheckGlobalNewDeleteFlagTestFixture::SetUp() NN_NOEXCEPT
{
    nnt::fs::util::ResetGlobalNewDeleteFlag();
    if ( m_Enabled )
    {
        nnt::fs::util::SetStackTraceDumpOnGlobalNewDeleteCallEnabled(true);
    }
}

void CheckGlobalNewDeleteFlagTestFixture::TearDown() NN_NOEXCEPT
{
    if (m_Enabled == true)
    {
        EXPECT_FALSE(nnt::fs::util::IsGlobalNewDeleteCalled());
    }
    nnt::fs::util::SetStackTraceDumpOnGlobalNewDeleteCallEnabled(false);
}

void CheckGlobalNewDeleteFlagTestFixture::DisableCheck() NN_NOEXCEPT
{
    m_Enabled = false;
    nnt::fs::util::SetStackTraceDumpOnGlobalNewDeleteCallEnabled(false);
}


// PrepareWorkDirFixture
PrepareWorkDirFixture::PrepareWorkDirFixture() NN_NOEXCEPT
{
}

void PrepareWorkDirFixture::CreateWorkRootPath() NN_NOEXCEPT
{
    m_HostDirectory.Create();
}

void PrepareWorkDirFixture::DeleteWorkRootPath() NN_NOEXCEPT
{
    m_HostDirectory.Delete();
}

String PrepareWorkDirFixture::GetWorkRootPath() NN_NOEXCEPT
{
    return m_HostDirectory.GetPath();
}

}}}
