﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../Common/testFriends_Common.h"

#include <nn/friends/detail/service/core/friends_ParameterConverter.h>

using namespace nn::friends::detail::service::core;

TEST(FriendsPlayLogMerge, AddSimple)
{
    nn::friends::PlayLog basePlayLogs[3] =
    {
        // appInfo, totalPlayCount, totalPlayTime, firstPlayedTime, lastPlayedTime
        {{{0x0000000000000001ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000002ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000003ull}, 0ll}, 100, 100, {1000}, {2000}}
    };

    nn::friends::PlayLog addPlayLogs[3] =
    {
        // appInfo, totalPlayCount, totalPlayTime, firstPlayedTime, lastPlayedTime
        {{{0x0000000000000011ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000012ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000013ull}, 0ll}, 100, 100, {1000}, {2000}}
    };

    nn::friends::PlayLog mergedPlayLogs[nn::friends::PlayLogCountMax] = {};
    int mergedCount;

    ParameterConverter::MergePlayLog(&mergedCount, mergedPlayLogs,
        basePlayLogs, NN_ARRAY_SIZE(basePlayLogs), addPlayLogs, NN_ARRAY_SIZE(addPlayLogs), NN_ARRAY_SIZE(mergedPlayLogs));

    EXPECT_EQ(mergedCount, 6);
    EXPECT_EQ(mergedPlayLogs[0].appInfo.appId.value, 0x0000000000000011ull);
    EXPECT_EQ(mergedPlayLogs[1].appInfo.appId.value, 0x0000000000000012ull);
    EXPECT_EQ(mergedPlayLogs[2].appInfo.appId.value, 0x0000000000000013ull);
    EXPECT_EQ(mergedPlayLogs[3].appInfo.appId.value, 0x0000000000000001ull);
    EXPECT_EQ(mergedPlayLogs[4].appInfo.appId.value, 0x0000000000000002ull);
    EXPECT_EQ(mergedPlayLogs[5].appInfo.appId.value, 0x0000000000000003ull);
}

TEST(FriendsPlayLogMerge, Same)
{
    nn::friends::PlayLog basePlayLogs[3] =
    {
        // appInfo, totalPlayCount, totalPlayTime, firstPlayedTime, lastPlayedTime
        {{{0x0000000000000001ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000002ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000003ull}, 0ll}, 100, 100, {1000}, {2000}}
    };

    nn::friends::PlayLog addPlayLogs[3] =
    {
        // appInfo, totalPlayCount, totalPlayTime, firstPlayedTime, lastPlayedTime
        {{{0x0000000000000001ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000002ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000003ull}, 0ll}, 100, 100, {1000}, {2000}}
    };

    nn::friends::PlayLog mergedPlayLogs[nn::friends::PlayLogCountMax] = {};
    int mergedCount;

    ParameterConverter::MergePlayLog(&mergedCount, mergedPlayLogs,
        basePlayLogs, NN_ARRAY_SIZE(basePlayLogs), addPlayLogs, NN_ARRAY_SIZE(addPlayLogs), NN_ARRAY_SIZE(mergedPlayLogs));

    EXPECT_EQ(mergedCount, 3);
    EXPECT_EQ(mergedPlayLogs[0].appInfo.appId.value, 0x0000000000000001ull);
    EXPECT_EQ(mergedPlayLogs[1].appInfo.appId.value, 0x0000000000000002ull);
    EXPECT_EQ(mergedPlayLogs[2].appInfo.appId.value, 0x0000000000000003ull);
}

TEST(FriendsPlayLogMerge, Base0)
{
    nn::friends::PlayLog addPlayLogs[3] =
    {
        // appInfo, totalPlayCount, totalPlayTime, firstPlayedTime, lastPlayedTime
        {{{0x0000000000000001ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000002ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000003ull}, 0ll}, 100, 100, {1000}, {2000}}
    };

    nn::friends::PlayLog mergedPlayLogs[nn::friends::PlayLogCountMax] = {};
    int mergedCount;

    ParameterConverter::MergePlayLog(&mergedCount, mergedPlayLogs,
        nullptr, 0, addPlayLogs, NN_ARRAY_SIZE(addPlayLogs), NN_ARRAY_SIZE(mergedPlayLogs));

    EXPECT_EQ(mergedCount, 3);
    EXPECT_EQ(mergedPlayLogs[0].appInfo.appId.value, 0x0000000000000001ull);
    EXPECT_EQ(mergedPlayLogs[1].appInfo.appId.value, 0x0000000000000002ull);
    EXPECT_EQ(mergedPlayLogs[2].appInfo.appId.value, 0x0000000000000003ull);
}

TEST(FriendsPlayLogMerge, Add0)
{
    nn::friends::PlayLog basePlayLogs[3] =
    {
        // appInfo, totalPlayCount, totalPlayTime, firstPlayedTime, lastPlayedTime
        {{{0x0000000000000001ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000002ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000003ull}, 0ll}, 100, 100, {1000}, {2000}}
    };

    nn::friends::PlayLog mergedPlayLogs[nn::friends::PlayLogCountMax] = {};
    int mergedCount;

    ParameterConverter::MergePlayLog(&mergedCount, mergedPlayLogs,
        basePlayLogs, NN_ARRAY_SIZE(basePlayLogs), nullptr, 0, NN_ARRAY_SIZE(mergedPlayLogs));

    EXPECT_EQ(mergedCount, 3);
    EXPECT_EQ(mergedPlayLogs[0].appInfo.appId.value, 0x0000000000000001ull);
    EXPECT_EQ(mergedPlayLogs[1].appInfo.appId.value, 0x0000000000000002ull);
    EXPECT_EQ(mergedPlayLogs[2].appInfo.appId.value, 0x0000000000000003ull);
}

TEST(FriendsPlayLogMerge, Overwrite1)
{
    nn::friends::PlayLog basePlayLogs[20] =
    {
        // appInfo, totalPlayCount, totalPlayTime, firstPlayedTime, lastPlayedTime
        {{{0x0000000000000001ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000002ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000003ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000004ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000005ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000006ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000007ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000008ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000009ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000010ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000011ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000012ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000013ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000014ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000015ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000016ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000017ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000018ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000019ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000020ull}, 0ll}, 100, 100, {1000}, {2000}}
    };

    nn::friends::PlayLog addPlayLogs[5] =
    {
        // appInfo, totalPlayCount, totalPlayTime, firstPlayedTime, lastPlayedTime
        {{{0x0000000000000101ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000102ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000103ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000104ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000105ull}, 0ll}, 100, 100, {1000}, {2000}}
    };

    nn::friends::PlayLog mergedPlayLogs[nn::friends::PlayLogCountMax] = {};
    int mergedCount;

    ParameterConverter::MergePlayLog(&mergedCount, mergedPlayLogs,
        basePlayLogs, NN_ARRAY_SIZE(basePlayLogs), addPlayLogs, NN_ARRAY_SIZE(addPlayLogs), NN_ARRAY_SIZE(mergedPlayLogs));

    EXPECT_EQ(mergedCount, NN_ARRAY_SIZE(mergedPlayLogs));

    for (int i = 0; i < NN_ARRAY_SIZE(addPlayLogs); i++)
    {
        EXPECT_EQ(mergedPlayLogs[i].appInfo.appId, addPlayLogs[i].appInfo.appId);
    }
    for (int i = NN_ARRAY_SIZE(addPlayLogs); i < NN_ARRAY_SIZE(mergedPlayLogs); i++)
    {
        EXPECT_EQ(mergedPlayLogs[i].appInfo.appId, basePlayLogs[i - NN_ARRAY_SIZE(addPlayLogs)].appInfo.appId);
    }
}

TEST(FriendsPlayLogMerge, Overwrite2)
{
    nn::friends::PlayLog basePlayLogs[20] =
    {
        // appInfo, totalPlayCount, totalPlayTime, firstPlayedTime, lastPlayedTime
        {{{0x0000000000000001ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000002ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000003ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000004ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000005ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000006ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000007ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000008ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000009ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000010ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000011ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000012ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000013ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000014ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000015ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000016ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000017ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000018ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000019ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000020ull}, 0ll}, 100, 100, {1000}, {2000}}
    };

    nn::friends::PlayLog addPlayLogs[20] =
    {
        // appInfo, totalPlayCount, totalPlayTime, firstPlayedTime, lastPlayedTime
        {{{0x0000000000000101ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000102ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000103ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000104ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000105ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000106ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000107ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000108ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000109ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000110ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000111ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000112ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000113ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000114ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000115ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000116ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000117ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000118ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000119ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000120ull}, 0ll}, 100, 100, {1000}, {2000}}
    };

    nn::friends::PlayLog mergedPlayLogs[nn::friends::PlayLogCountMax] = {};
    int mergedCount;

    ParameterConverter::MergePlayLog(&mergedCount, mergedPlayLogs,
        basePlayLogs, NN_ARRAY_SIZE(basePlayLogs), addPlayLogs, NN_ARRAY_SIZE(addPlayLogs), NN_ARRAY_SIZE(mergedPlayLogs));

    EXPECT_EQ(mergedCount, NN_ARRAY_SIZE(mergedPlayLogs));

    for (int i = 0; i < NN_ARRAY_SIZE(mergedPlayLogs); i++)
    {
        EXPECT_EQ(mergedPlayLogs[i].appInfo.appId, addPlayLogs[i].appInfo.appId);
    }
}

TEST(FriendsPlayLogMerge, Merge)
{
    nn::friends::PlayLog playLogs1[5] =
    {
        // appInfo, totalPlayCount, totalPlayTime, firstPlayedTime, lastPlayedTime
        {{{0x0000000000000001ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000002ull}, 0ll}, 101, 100, {1000}, {2000}},
        {{{0x0000000000000003ull}, 0ll}, 100, 101, {1000}, {2000}},
        {{{0x0000000000000004ull}, 0ll}, 100, 100, { 999}, {2000}},
        {{{0x0000000000000005ull}, 0ll}, 100, 100, {1000}, {2001}}
    };

    nn::friends::PlayLog playLogs2[5] =
    {
        // appInfo, totalPlayCount, totalPlayTime, firstPlayedTime, lastPlayedTime
        {{{0x0000000000000001ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000002ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000003ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000004ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000005ull}, 0ll}, 100, 100, {1000}, {2000}}
    };

    nn::friends::PlayLog mergedPlayLogs[nn::friends::PlayLogCountMax] = {};
    int mergedCount;

    // 1 <- 2
    ParameterConverter::MergePlayLog(&mergedCount, mergedPlayLogs,
        playLogs1, NN_ARRAY_SIZE(playLogs1), playLogs2, NN_ARRAY_SIZE(playLogs2), NN_ARRAY_SIZE(mergedPlayLogs));

    EXPECT_EQ(mergedCount, 5);

    EXPECT_EQ(mergedPlayLogs[0].appInfo.appId.value, 0x0000000000000001ull);

    EXPECT_EQ(mergedPlayLogs[1].appInfo.appId.value, 0x0000000000000002ull);
    EXPECT_EQ(mergedPlayLogs[1].totalPlayCount, 101);

    EXPECT_EQ(mergedPlayLogs[2].appInfo.appId.value, 0x0000000000000003ull);
    EXPECT_EQ(mergedPlayLogs[2].totalPlayTime, 101);

    EXPECT_EQ(mergedPlayLogs[3].appInfo.appId.value, 0x0000000000000004ull);
    EXPECT_EQ(mergedPlayLogs[3].firstPlayedTime.value, 999);

    EXPECT_EQ(mergedPlayLogs[4].appInfo.appId.value, 0x0000000000000005ull);
    EXPECT_EQ(mergedPlayLogs[4].lastPlayedTime.value, 2001);

    // 2 <- 1
    ParameterConverter::MergePlayLog(&mergedCount, mergedPlayLogs,
        playLogs2, NN_ARRAY_SIZE(playLogs2), playLogs1, NN_ARRAY_SIZE(playLogs1), NN_ARRAY_SIZE(mergedPlayLogs));

    EXPECT_EQ(mergedCount, 5);

    EXPECT_EQ(mergedPlayLogs[0].appInfo.appId.value, 0x0000000000000001ull);

    EXPECT_EQ(mergedPlayLogs[1].appInfo.appId.value, 0x0000000000000002ull);
    EXPECT_EQ(mergedPlayLogs[1].totalPlayCount, 101);

    EXPECT_EQ(mergedPlayLogs[2].appInfo.appId.value, 0x0000000000000003ull);
    EXPECT_EQ(mergedPlayLogs[2].totalPlayTime, 101);

    EXPECT_EQ(mergedPlayLogs[3].appInfo.appId.value, 0x0000000000000004ull);
    EXPECT_EQ(mergedPlayLogs[3].firstPlayedTime.value, 999);

    EXPECT_EQ(mergedPlayLogs[4].appInfo.appId.value, 0x0000000000000005ull);
    EXPECT_EQ(mergedPlayLogs[4].lastPlayedTime.value, 2001);
}

TEST(FriendsPlayLogMerge, AddOrMerge)
{
    nn::friends::PlayLog basePlayLogs[5] =
    {
        // appInfo, totalPlayCount, totalPlayTime, firstPlayedTime, lastPlayedTime
        {{{0x0000000000000001ull}, 0ll}, 101, 100, {1000}, {2000}},
        {{{0x0000000000000002ull}, 0ll}, 100, 101, {1000}, {2000}},
        {{{0x0000000000000003ull}, 0ll}, 100, 100, { 999}, {2000}},
        {{{0x0000000000000004ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000005ull}, 0ll}, 100, 100, {1000}, {2000}}
    };

    nn::friends::PlayLog addPlayLogs[5] =
    {
        // appInfo, totalPlayCount, totalPlayTime, firstPlayedTime, lastPlayedTime
        {{{0x000000000000000Aull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000001ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000002ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x0000000000000003ull}, 0ll}, 100, 100, {1000}, {2000}},
        {{{0x000000000000000Bull}, 0ll}, 100, 100, {1000}, {2000}}
    };

    nn::friends::PlayLog mergedPlayLogs[nn::friends::PlayLogCountMax] = {};
    int mergedCount;

    ParameterConverter::MergePlayLog(&mergedCount, mergedPlayLogs,
        basePlayLogs, NN_ARRAY_SIZE(basePlayLogs), addPlayLogs, NN_ARRAY_SIZE(addPlayLogs), NN_ARRAY_SIZE(mergedPlayLogs));

    EXPECT_EQ(mergedCount, 7);

    EXPECT_EQ(mergedPlayLogs[0].appInfo.appId.value, 0x000000000000000Aull);

    EXPECT_EQ(mergedPlayLogs[1].appInfo.appId.value, 0x0000000000000001ull);
    EXPECT_EQ(mergedPlayLogs[1].totalPlayCount, 101);

    EXPECT_EQ(mergedPlayLogs[2].appInfo.appId.value, 0x0000000000000002ull);
    EXPECT_EQ(mergedPlayLogs[2].totalPlayTime, 101);

    EXPECT_EQ(mergedPlayLogs[3].appInfo.appId.value, 0x0000000000000003ull);
    EXPECT_EQ(mergedPlayLogs[3].firstPlayedTime.value, 999);

    EXPECT_EQ(mergedPlayLogs[4].appInfo.appId.value, 0x000000000000000Bull);

    EXPECT_EQ(mergedPlayLogs[5].appInfo.appId.value, 0x0000000000000004ull);

    EXPECT_EQ(mergedPlayLogs[6].appInfo.appId.value, 0x0000000000000005ull);
}
