﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/fatalsrv/fatalsrv_Service.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>

#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>
#include <nnt/result/testResult_Assert.h>

#include "../../../../Programs/Eris/Sources/Libraries/fatalsrv/fatalsrv_Environment.h"

namespace {
    class MultipleCallTest : public testing::Test
    {
    protected:
        virtual void SetUp()
        {
        }

        virtual void TearDown()
        {
        }

        static void SetUpTestCase()
        {
            nn::fatalsrv::InitializeEnvironmentInfo();
        }

        static void TearDownTestCase()
        {
        }

    private:
    };

}

namespace
{
}


TEST_F(MultipleCallTest, Basic)
{
    nn::fatalsrv::Service service;
    nn::fatalsrv::FatalContext fatalContext = {};
    NNT_ASSERT_RESULT_SUCCESS(service.ThrowFatal(fatalContext, 0));
    NNT_ASSERT_RESULT_FAILURE(nn::fatal::ResultAlreadyFatalThrown, service.ThrowFatal(fatalContext, 0));
}
