﻿/*
 *  Copyright 2005-2014 Acer Cloud Technology, Inc.
 *  All Rights Reserved.
 *
 *  This software contains confidential information and
 *  trade secrets of Acer Cloud Technology, Inc.
 *  Use, disclosure or reproduction is prohibited without
 *  the prior express written permission of Acer Cloud
 *  Technology, Inc.
 */

/*
 *               Copyright (C) 2008, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished proprietary information of BroadOn Communications Corp.,
 *  and are protected by Federal copyright law. They may not be disclosed
 *  to third parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */
#include <nnt/nntest.h>
#include <nn/nn_Macro.h>

#define TESTNAME "SignVerTest"
#define NEED_NUMTICKS

#include "testEs_Testcommon.h"

#include <nn/ioscrypto/iosccert.h>

#define ERROR_CHECK( err )                               \
    if( err != IOSC_ERROR_OK )                           \
    {                                                    \
        TUL_LogFail( TESTNAME, "error in IOSC call\n" ); \
        EXIT( -1 );                                      \
    }

NN_ALIGNAS( ALIGN_SIZE ) static IOSCEccSignedCert appcert;

#ifdef USE_OBSOLETE_CODE
IOSCError createEncryptedRandoms( IOSCSecretKeyHandle handle, u8 *iv, u8 *rand, u32 size )
{
    IOSCError error;
    int i;
    /* Encrypt randoms - somewhere else ! */
    for( i = 0; i < size; i++ )
    {
        rand[i] = i;
    }
    for( i = 0; i < sizeof( IOSCAesIv ); i++ )
    {
        iv[i] = i + 1;
    }

    error = IOSC_Encrypt( handle, iv, rand, size, rand );

    if( error != IOSC_ERROR_OK )
    {
        return error;
    }
    /* reset IV */
    for( i = 0; i < sizeof( IOSCAesIv ); i++ )
    {
        iv[i] = i + 1;
    }
    return error;
}
#endif

int doSignVerTest()
{
    IOSCKeyHandle keypair;
    IOSCSecretKeyHandle signkeyh;
    IOSCPublicKeyHandle verifykeyh;
    u8 hash[20];
    IOSCEccSig signData;
    int i, iter;
    IOSCError error;
    IOSCCertName appname;

#ifdef PERF
    u32 startTime, endTime;
#endif

    /*
     * Test of priv key sign: IOSC_GeneratePublicKeySign
     */
    for( iter = 0; iter < 5; iter++ )
    {
        error = IOSC_CreateObject( &signkeyh, IOSC_SECRETKEY_TYPE, IOSC_ECC233_SUBTYPE );
        ERROR_CHECK( error );
        error = IOSC_GenerateKey( signkeyh );
        ERROR_CHECK( error );
        /* init hash */
        for( i = 0; i < sizeof( hash ); i++ )
        {
            hash[i] = i & 0xff;
        }
#ifdef PERF
        startTime = IO_READ( SYS_TIMER_REG );
#endif
        IOSC_GeneratePublicKeySign( hash, sizeof( hash ), signkeyh, signData );
#ifdef PERF
        endTime = IO_READ( SYS_TIMER_REG );
        NN_LOG( "Number of Ticks for IOSC_GeneratePublicKeySign (ECC)= %d, Time = %d us\n", getNumTicks( startTime, endTime ),
                getNumTicks( startTime, endTime ) * NUM_TICKS / CLOCK_FREQ );
#endif
        /* import public keys: get them by getting certs */
        memset( appname, 0x0, sizeof( IOSCCertName ) );
        memcpy( appname, "APP00000001", sizeof( "APP00000001" ) );
        error = IOSC_GenerateCertificate( signkeyh, appname, &appcert );
        ERROR_CHECK( error );

        /* import public keys */
        error = IOSC_CreateObject( &verifykeyh, IOSC_PUBLICKEY_TYPE, IOSC_ECC233_SUBTYPE );

        ERROR_CHECK( error );
        error = IOSC_ImportPublicKey( ( (IOSCEccEccCert *)appcert )->pubKey, 0, verifykeyh );
        ERROR_CHECK( error );
#ifdef PERF
        startTime = IO_READ( SYS_TIMER_REG );
#endif
        error = IOSC_VerifyPublicKeySign( hash, sizeof( hash ), verifykeyh, signData );
#ifdef PERF
        endTime = IO_READ( SYS_TIMER_REG );
        NN_LOG( "Number of Ticks for IOSC_VerifyPublicKeySign (ECC)= %d, Time = %d us\n", getNumTicks( startTime, endTime ),
                getNumTicks( startTime, endTime ) * NUM_TICKS / CLOCK_FREQ );
#endif
        if( error == 0 )
        {
            LOG_PASS( "Sign verify" );
        }
        else
        {
            LOG_FAIL( "Sign verify" );
        }

        /* Negative test */
        /* perturb hash for negative test*/
        hash[( iter % 20 )] ^= ( 0x01 ) << ( iter % 7 );
        error = IOSC_VerifyPublicKeySign( hash, sizeof( hash ), verifykeyh, signData );
        if( error == 0 )
        {
            LOG_FAIL( "Sign verify Neg Test FAIL, , iter = %d", iter );
            EXIT( -1 );
        }
        else
        {
            LOG_PASS( "Sign verify keypair Neg Test PASS, iter = %d", iter );
        }
        IOSC_DeleteObject( signkeyh );
        IOSC_DeleteObject( verifykeyh );
    }

    /* sign verify test with key pair type*/
    for( iter = 0; iter < 10; iter++ )
    {
        /* change data */
        for( i = 0; i < sizeof( hash ); i++ )
        {
            hash[i] = ( i + iter ) & 0xff;
        }
        error = IOSC_CreateObject( &keypair, IOSC_KEYPAIR_TYPE, IOSC_ECC233_SUBTYPE );
        ERROR_CHECK( error );
        error = IOSC_GenerateKey( keypair );
        ERROR_CHECK( error );
        error = IOSC_GeneratePublicKeySign( hash, sizeof( hash ), keypair, signData );
        ERROR_CHECK( error );
        error = IOSC_VerifyPublicKeySign( hash, sizeof( hash ), keypair, signData );
        ERROR_CHECK( error );
        if( error == 0 )
        {
            LOG_PASS( "Sign verify keypair PASS, iter = %d", iter );
        }
        else
        {
            LOG_FAIL( "Sign verify keypair FAIL, iter = %d", iter );
            EXIT( -1 );
        }

        /* perturb hash for negative test*/
        hash[( iter % 20 )] ^= ( 0x01 ) << ( iter % 7 );
        error = IOSC_VerifyPublicKeySign( hash, sizeof( hash ), keypair, signData );
        if( error == 0 )
        {
            LOG_FAIL( "Sign verify keypair Neg Test FAIL, iter = %d", iter );
            EXIT( -1 );
        }
        else
        {
            LOG_PASS( "Sign verify keypair Neg Test PASS, iter = %d", iter );
        }
        IOSC_DeleteObject( keypair );
    }

    return 0;
}

#if defined( SEPARATE_MAIN_PROGRAM )

int main( int argc, char **argv )
{
    IOSC_Initialize();
    doSignVerTest();
    EXIT( 0 );
    return 0;
}
#endif
