﻿/*
 *  Copyright 2005-2014 Acer Cloud Technology, Inc.
 *  All Rights Reserved.
 *
 *  This software contains confidential information and
 *  trade secrets of Acer Cloud Technology, Inc.
 *  Use, disclosure or reproduction is prohibited without
 *  the prior express written permission of Acer Cloud
 *  Technology, Inc.
 */

/*
 *               Copyright (C) 2008, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished  proprietary information of BroadOn Communications Corp.,
 *  and  are protected by Federal copyright law. They may not be disclosed
 *  to  third  parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */

/*
 * Main program to invoke crypto tests on RVL
 */
#include <cstdlib>

#include <nnt/nntest.h>
#include <nn/nn_Log.h>
#include <nn/fs.h>
#include <nn/spl/spl_Api.h>

//#include <types.h>
//#include <iostypes.h>
#include <nn/iosc/iosc.h>
#include <nn/ioscrypto/iosccert.h>

//#include <ioslibc.h>

#include "testEs_Common.h"

extern int doHandleTests();
extern int doHashTests();
extern int doSha1Tests();
extern int doSha256Tests();
extern int doHmacTests();
extern int doEncDecTests();
extern int doKeyGenTest();
extern int doSignVerTest();
extern int doProtTest();
extern int doCertTest();
extern int doRsaVerTest();
extern int doEccRefTest();
extern int doRngTests();
extern int doNinDevCertTest();

#include "../Common/testEs_Device.cpp"

/**
    @brief FS用アロケータ
 */
void* Allocate(size_t size)
{
    return std::malloc(size);
}

/**
    @brief FS用デアロケータ
 */
void Deallocate(void* p, size_t size)
{
    NN_UNUSED(size);
    std::free(p);
}

TEST( CryptoRegressionTest, CryptoRegression )
{
    IOSC_Initialize();
    IOSC_SetDevicePrivateKey( &deviceKeyNX6100000000000001 );
    nn::fs::SetAllocator(Allocate, Deallocate);
    nn::fs::MountHostRoot();

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    nn::spl::InitializeForEs();
#endif

#ifdef USE_OBSOLETE_CODE
    doHandleTests();
    doSignVerTest();
    doKeyGenTest();
    doRsaVerTest();
    doHmacTests();
    doEccRefTest();

    doProtTest();
    doCertTest();
    doHashTests();
    doEncDecTests();
    doRngTests();

    NN_LOG( "\nPrinting to check Stack Usage!\n\n" );
    IOS_GetUsage( IOS_USAGE_THREADS );
#else
    doHandleTests();
    doSignVerTest();
    doKeyGenTest();
    doRsaVerTest();
    doEccRefTest();
    doSha1Tests();
    doSha256Tests();
    doRngTests();
    doEncDecTests();
    doCertTest();
    doNinDevCertTest();
#endif

    NN_LOG( "\nAll Tests Successful!\n" );

    return;
}
