﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/esUtil/testEs_Utility.h>
#include <nn/escorei/esitypes.h>

namespace nnt { namespace es {

    bool operator==(const nn::es::TicketInfo& lhs, const nn::es::TicketInfo& rhs) NN_NOEXCEPT
    {
        return lhs.accountId == rhs.accountId && lhs.deviceId == rhs.deviceId && lhs.rightsId == rhs.rightsId && lhs.ticketId == rhs.ticketId && lhs.ticketSize == rhs.ticketSize;
    }

    bool operator!=(const nn::es::TicketInfo& lhs, const nn::es::TicketInfo& rhs) NN_NOEXCEPT
    {
        return !(lhs == rhs);
    }

    bool operator==(const nn::es::PrepurchaseRecord& lhs, const nn::es::PrepurchaseRecord& rhs) NN_NOEXCEPT
    {
        return lhs.accountId == rhs.accountId && lhs.deliveryScheduledTime == rhs.deliveryScheduledTime && lhs.rightsId == rhs.rightsId && lhs.ticketId == rhs.ticketId;
    }

    bool operator!=(const nn::es::PrepurchaseRecord& lhs, const nn::es::PrepurchaseRecord& rhs) NN_NOEXCEPT
    {
        return !(lhs == rhs);
    }

    nn::es::TicketInfo CreateTicketInfo(const void * ticket, size_t ticketSize) NN_NOEXCEPT
    {
        nn::escore::ESV2Ticket* ticketStruct = (nn::escore::ESV2Ticket*)ticket;

        nn::es::TicketInfo ticketInfo;
        ticketInfo.ticketSize = ticketSize;
        ticketInfo.accountId = ticketStruct->accountId;
        ticketInfo.deviceId = ticketStruct->deviceId;
        ticketInfo.ticketId = ticketStruct->ticketId;
        std::memcpy(&ticketInfo.rightsId, ticketStruct->rightsId, sizeof(nn::es::RightsIdIncludingKeyId));

        return ticketInfo;
    }
}}
