﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/es.h>
#include <nn/publish/publish.h>

namespace {
    const uint8_t issuerName[] = "Root-CA00000004-XS00000020";

    uint8_t rsaPubMod[256] = {
        0xBA, 0x27, 0x84, 0x28, 0x76, 0x5D, 0x87, 0x9A, 0x7F, 0x21, 0x54, 0x04, 0xC6, 0xEE, 0x4E, 0x0A, 0x0D, 0x3F, 0x66, 0xC3, 0x3B, 0xC7, 0xF8, 0xA3,
        0x2F, 0xD8, 0x98, 0xE5, 0x2C, 0xB7, 0xB6, 0x34, 0x43, 0xCE, 0xD8, 0xB0, 0x05, 0x27, 0xD8, 0x9D, 0xED, 0xC6, 0xBB, 0xF6, 0x0A, 0xD1, 0xC5, 0xC9,
        0x92, 0x30, 0x21, 0xDD, 0x55, 0x5F, 0x9B, 0xAD, 0x4B, 0xE0, 0xC0, 0xC4, 0x06, 0xD3, 0x70, 0x29, 0x15, 0xE5, 0xB3, 0x4A, 0xC2, 0xD2, 0xAB, 0xE5,
        0x03, 0xC3, 0x2A, 0x3A, 0x23, 0xB4, 0x38, 0x34, 0xC9, 0x15, 0x7B, 0x9A, 0x0A, 0xF2, 0xE4, 0xE9, 0xC0, 0x3B, 0xED, 0xE2, 0xB4, 0xC1, 0x15, 0xF5,
        0x35, 0x3D, 0xFC, 0x66, 0xBD, 0x04, 0xA6, 0xC0, 0x79, 0x97, 0x0E, 0x38, 0xCB, 0xDD, 0x5A, 0x50, 0xA2, 0xB9, 0x8F, 0xF2, 0xD7, 0x65, 0xFC, 0xF8,
        0x33, 0x81, 0xE9, 0xE0, 0xE8, 0x49, 0xC3, 0x57, 0x35, 0x78, 0x37, 0x8F, 0xF6, 0x59, 0x51, 0x61, 0x3E, 0x95, 0xF7, 0x5E, 0xE8, 0xEF, 0x26, 0x18,
        0x3A, 0x40, 0xAA, 0xE4, 0xA7, 0x6D, 0x73, 0x84, 0xEA, 0x47, 0x8D, 0x2C, 0xDC, 0xE8, 0x0F, 0xBA, 0x03, 0x21, 0xA6, 0xBF, 0x8D, 0x69, 0x98, 0x3C,
        0x3A, 0xA7, 0xAE, 0x54, 0x43, 0xB7, 0x2B, 0xFE, 0x41, 0x0B, 0xF1, 0x32, 0x3C, 0xBD, 0x88, 0xC3, 0x56, 0x0E, 0xA1, 0x3D, 0x17, 0xD3, 0x8A, 0x2E,
        0x34, 0x04, 0x1D, 0xE7, 0xAA, 0xF3, 0x89, 0xDE, 0x43, 0x75, 0x22, 0x5C, 0xA8, 0x7E, 0xE3, 0x49, 0xC7, 0x60, 0xC7, 0xD9, 0x9B, 0xE7, 0xE7, 0x37,
        0xC6, 0x26, 0x1C, 0xC7, 0x4E, 0x25, 0xAE, 0x46, 0x52, 0x7A, 0xC9, 0x61, 0x9F, 0x93, 0x90, 0x57, 0x08, 0x8D, 0x74, 0x35, 0xA6, 0xDE, 0x7B, 0x25,
        0xAB, 0x82, 0xDD, 0x54, 0x10, 0xF2, 0x57, 0x9C, 0xAE, 0xF1, 0x49, 0x1A, 0x90, 0x9D, 0x30, 0x2B,
    };

    uint8_t rsaPrivExp[256] = {
        0x51, 0x02, 0x71, 0x58, 0xCA, 0x69, 0xD9, 0x61, 0x3A, 0x81, 0xDE, 0x76, 0x55, 0xBB, 0xCE, 0xEA, 0x40, 0xE9, 0x9E, 0x66, 0xC7, 0xD5, 0x36, 0x36,
        0x8D, 0xD3, 0xCC, 0x75, 0xAF, 0x08, 0x23, 0x9A, 0x8B, 0x07, 0xB0, 0xF4, 0xA8, 0xC9, 0xB6, 0x52, 0xC3, 0xEF, 0x00, 0x4D, 0x0A, 0x58, 0x4F, 0xA2,
        0x70, 0xA3, 0xD1, 0x98, 0xE8, 0x56, 0x3B, 0x01, 0x27, 0x4C, 0x1F, 0x97, 0x2F, 0x01, 0x44, 0x86, 0x1C, 0xA9, 0x61, 0x64, 0xDF, 0x73, 0x9E, 0xAA,
        0x83, 0x00, 0xA3, 0x97, 0xB9, 0x81, 0xEC, 0x13, 0xCC, 0x8E, 0x34, 0xC3, 0xCC, 0x8F, 0xF7, 0x5E, 0x61, 0xF1, 0xB2, 0x8C, 0x3D, 0xEC, 0xE9, 0x09,
        0x54, 0xAA, 0x2C, 0xF4, 0xE8, 0xBC, 0xE5, 0x74, 0x4D, 0x75, 0x97, 0x12, 0xD0, 0x64, 0xFB, 0xB0, 0xAB, 0x9F, 0xE5, 0x2C, 0xE0, 0xDF, 0xD9, 0x3E,
        0x89, 0xEB, 0xB7, 0x43, 0xD0, 0xD2, 0x88, 0xD6, 0xE4, 0xB3, 0xD4, 0xC9, 0x23, 0x67, 0xE0, 0xF5, 0xC4, 0x98, 0xDF, 0x4E, 0x12, 0x64, 0x53, 0xC3,
        0x92, 0xEB, 0x77, 0x72, 0xDC, 0x83, 0xBF, 0x11, 0xCD, 0x4B, 0x05, 0x1D, 0x43, 0x1C, 0x6A, 0x7D, 0x9F, 0x00, 0x1E, 0x1A, 0xB7, 0x50, 0x03, 0x0A,
        0xF0, 0x8C, 0x67, 0x52, 0x7F, 0x3E, 0xAD, 0x72, 0xC4, 0x39, 0x93, 0x3A, 0xB1, 0x66, 0xFC, 0x5F, 0x84, 0xCF, 0x1D, 0x0F, 0x47, 0xDC, 0x7A, 0xDC,
        0xEE, 0xAB, 0xB5, 0x5A, 0x44, 0x04, 0x5A, 0xA8, 0x0E, 0x07, 0xF4, 0xED, 0xDF, 0x56, 0x47, 0xCF, 0x8B, 0xDE, 0xA6, 0x26, 0x3C, 0x89, 0xD0, 0xDB,
        0xDD, 0xED, 0xD8, 0xF2, 0xA9, 0x76, 0x95, 0x7D, 0xA5, 0xDB, 0xD2, 0x8F, 0x8E, 0xF2, 0x31, 0xC7, 0x6A, 0xFB, 0x9F, 0xA4, 0xA7, 0x95, 0xE0, 0xBF,
        0x5F, 0x57, 0x48, 0x3C, 0x65, 0x60, 0x2A, 0x46, 0x2A, 0xDD, 0xA8, 0x58, 0xD8, 0x2F, 0x89, 0x81,
    };
}

namespace nnt { namespace es {

    uint32_t PublishTicket(void* ticketBuffer, uint32_t ticketSize, nn::es::TitleKey titleKey, nn::es::DeviceId deviceId, nn::es::TicketId ticketId, nn::es::RightsIdIncludingKeyId rightsId, nn::es::AccountId accountId) NN_NOEXCEPT
    {
        bcc::publish::PublishTicket ticket;

        ticket.SetTitleKey(reinterpret_cast<uint8_t*>(&titleKey.key));
        ticket.SetDeviceId(deviceId);
        ticket.SetTicketId(ticketId);
        ticket.SetRightsId(reinterpret_cast<uint8_t*>(&rightsId));
        ticket.SetAccountId(accountId);
        ticket.SignTicket(issuerName, rsaPubMod, rsaPrivExp);
        ticket.OutputTicket(reinterpret_cast<uint8_t*>(ticketBuffer), ticketSize);

        uint32_t length;
        ticket.GetTicketLen(&length);

        return length;
    }
}}
