﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ens/detail/core/ens_HttpTask.h>

namespace nnt { namespace ens {

/**
 * @brief   サービスエラーをシミュレートするタスク
 *
 * @details
 */
class TaskSimulateServiceError : public nn::ens::detail::core::HttpTask
{
public:
    /**
     * @brief   コンストラクタ
     *
     * @details
     */
    TaskSimulateServiceError() NN_NOEXCEPT;

    /**
     * @brief   デストラクタ
     *
     * @details
     */
    virtual ~TaskSimulateServiceError() NN_NOEXCEPT;

    /**
     * @brief   パラメータを設定します。
     *
     * @param[in]   statusCode  HTTP ステータスコード
     * @param[in]   pCategory   カテゴリ
     * @param[in]   pServerCode サーバーコード
     *
     * @pre
     *  - pCategory != nullptr
     *  - pServerCode != nullptr
     *
     * @details
     */
    void SetParameter(int statusCode, const char* pCategory, const char* pServerCode) NN_NOEXCEPT;

protected:
    //
    virtual nn::Result Main() NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    int m_StatusCode;
    const char* m_pCategory;
    const char* m_pServerCode;

private:
    //
    nn::Result StepSimulate() NN_NOEXCEPT;
};

}}
