﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ens/detail/core/ens_Task.h>

namespace nnt { namespace ens {

/**
 * @brief   入力を一定期間後に出力するタスク
 *
 * @details
 *  本タスクはキャンセル要求が来ても完了するまで停止しません。
 */
class TaskUnstoppableEcho : public nn::ens::detail::core::Task
{
public:
    /**
     * @brief   コンストラクタ
     *
     * @details
     */
    TaskUnstoppableEcho() NN_NOEXCEPT;

    /**
     * @brief   デストラクタ
     *
     * @details
     */
    virtual ~TaskUnstoppableEcho() NN_NOEXCEPT;

    /**
     * @brief   パラメータを設定します。
     *
     * @param[out]  pOutput 出力値
     * @param[in]   pInput  入力値
     * @param[in]   span    待機期間
     *
     * @details
     */
    void SetParameter(int* pOutput, int input, nn::TimeSpan span) NN_NOEXCEPT;

protected:
    //
    virtual nn::Result Main() NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    int* m_pOutput;
    int m_Input;
    //
    nn::TimeSpan m_Span;

private:
    //
    nn::Result StepWait() NN_NOEXCEPT;
};

}}
