﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testEns_TaskUnstoppableEcho.h"

namespace nnt { namespace ens {

TaskUnstoppableEcho::TaskUnstoppableEcho() NN_NOEXCEPT
    : m_pOutput(nullptr)
    , m_Input(0)
    , m_Span(0)
{
}

TaskUnstoppableEcho::~TaskUnstoppableEcho() NN_NOEXCEPT
{
}

void TaskUnstoppableEcho::SetParameter(int* pOutput, int input, nn::TimeSpan span) NN_NOEXCEPT
{
    m_pOutput = pOutput;
    m_Input = input;

    m_Span = span;
}

nn::Result TaskUnstoppableEcho::Main() NN_NOEXCEPT
{
    NN_RESULT_DO(StepWait());

    NN_RESULT_SUCCESS;
}

nn::Result TaskUnstoppableEcho::StepWait() NN_NOEXCEPT
{
    nn::os::SleepThread(m_Span);

    std::lock_guard<decltype (GetParameterLock())> lock(GetParameterLock());

    if (IsAsyncContextRegistered())
    {
        *m_pOutput = m_Input;
    }

    NN_RESULT_SUCCESS;
}

}}
